/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.serialize;

import com.fasterxml.jackson.databind.ObjectMapper;
import it.unibo.tuprolog.serialize.JvmTheoryObjectifier;
import it.unibo.tuprolog.serialize.MimeType;
import it.unibo.tuprolog.serialize.MimeTypeExtensions;
import it.unibo.tuprolog.serialize.WritingTheorySerializer;
import it.unibo.tuprolog.theory.Theory;
import java.io.Writer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lit/unibo/tuprolog/serialize/JvmTheorySerializer;", "Lit/unibo/tuprolog/serialize/WritingTheorySerializer;", "mimeType", "Lit/unibo/tuprolog/serialize/MimeType;", "(Lit/unibo/tuprolog/serialize/MimeType;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMimeType", "()Lit/unibo/tuprolog/serialize/MimeType;", "objectifier", "Lit/unibo/tuprolog/serialize/JvmTheoryObjectifier;", "serialize", "", "writer", "Ljava/io/Writer;", "value", "Lit/unibo/tuprolog/theory/Theory;", "serializeMany", "values", "", "serialize-theory"})
public final class JvmTheorySerializer
implements WritingTheorySerializer {
    @NotNull
    private final MimeType mimeType;
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private final JvmTheoryObjectifier objectifier;

    public JvmTheorySerializer(@NotNull MimeType mimeType) {
        Intrinsics.checkNotNullParameter(mimeType, "mimeType");
        this.mimeType = mimeType;
        this.mapper = MimeTypeExtensions.getObjectMapper(this.getMimeType());
        this.objectifier = new JvmTheoryObjectifier();
    }

    @Override
    @NotNull
    public MimeType getMimeType() {
        return this.mimeType;
    }

    @Override
    public void serialize(@NotNull Writer writer, @NotNull Theory value) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        Intrinsics.checkNotNullParameter(value, "value");
        this.mapper.writeValue(writer, this.objectifier.objectify(value));
    }

    @Override
    public void serializeMany(@NotNull Writer writer, @NotNull Iterable<? extends Theory> values2) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        Intrinsics.checkNotNullParameter(values2, "values");
        this.mapper.writeValue(writer, this.objectifier.objectifyMany(values2));
    }

    @Override
    @NotNull
    public String serialize(@NotNull Theory value) {
        return WritingTheorySerializer.DefaultImpls.serialize(this, value);
    }

    @Override
    @NotNull
    public String serializeMany(@NotNull Iterable<? extends Theory> values2) {
        return WritingTheorySerializer.DefaultImpls.serializeMany((WritingTheorySerializer)this, values2);
    }

    @Override
    @NotNull
    public String serializeMany(@NotNull Sequence<? extends Theory> values2) {
        return WritingTheorySerializer.DefaultImpls.serializeMany((WritingTheorySerializer)this, values2);
    }

    @NotNull
    public String serializeMany(Theory ... values2) {
        return WritingTheorySerializer.DefaultImpls.serializeMany((WritingTheorySerializer)this, values2);
    }

    @Override
    public void serializeMany(@NotNull Writer writer, @NotNull Sequence<? extends Theory> values2) {
        WritingTheorySerializer.DefaultImpls.serializeMany((WritingTheorySerializer)this, writer, values2);
    }

    public void serializeMany(@NotNull Writer writer, Theory ... values2) {
        WritingTheorySerializer.DefaultImpls.serializeMany((WritingTheorySerializer)this, writer, values2);
    }
}

