/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.serialize;

import it.unibo.tuprolog.core.Atom;
import it.unibo.tuprolog.core.Block;
import it.unibo.tuprolog.core.Clause;
import it.unibo.tuprolog.core.Cons;
import it.unibo.tuprolog.core.Constant;
import it.unibo.tuprolog.core.Directive;
import it.unibo.tuprolog.core.Empty;
import it.unibo.tuprolog.core.EmptyBlock;
import it.unibo.tuprolog.core.EmptyList;
import it.unibo.tuprolog.core.Fact;
import it.unibo.tuprolog.core.Indicator;
import it.unibo.tuprolog.core.Integer;
import it.unibo.tuprolog.core.Numeric;
import it.unibo.tuprolog.core.Real;
import it.unibo.tuprolog.core.Recursive;
import it.unibo.tuprolog.core.Rule;
import it.unibo.tuprolog.core.Struct;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.Truth;
import it.unibo.tuprolog.core.Tuple;
import it.unibo.tuprolog.core.Var;
import it.unibo.tuprolog.serialize.TermObjectifier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u0005\u001a\u00020\u000fH\u0016J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u0005\u001a\u00020\u0011H\u0016J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u0005\u001a\u00020\u0013H\u0016J\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u0005\u001a\u00020\u0015H\u0016J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u0005\u001a\u00020\u0017H\u0016J\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u0005\u001a\u00020\u0019H\u0016J\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u0005\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001dH\u0016J\u001c\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u0005\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020!H\u0016J\u001c\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u0005\u001a\u00020#H\u0016J\u001c\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u0005\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020'H\u0016J\u001c\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u0005\u001a\u00020)H\u0016J\u001c\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u0005\u001a\u00020+H\u0016\u00a8\u0006,"}, d2={"Lit/unibo/tuprolog/serialize/JvmTermObjectifier;", "Lit/unibo/tuprolog/serialize/TermObjectifier;", "()V", "defaultValue", "", "term", "Lit/unibo/tuprolog/core/Term;", "objectifyMany", "values", "", "visitAtom", "", "Lit/unibo/tuprolog/core/Atom;", "visitBlock", "", "Lit/unibo/tuprolog/core/Block;", "visitCons", "Lit/unibo/tuprolog/core/Cons;", "visitDirective", "Lit/unibo/tuprolog/core/Directive;", "visitEmptyBlock", "Lit/unibo/tuprolog/core/EmptyBlock;", "visitEmptyList", "Lit/unibo/tuprolog/core/EmptyList;", "visitFact", "Lit/unibo/tuprolog/core/Fact;", "visitIndicator", "Lit/unibo/tuprolog/core/Indicator;", "visitInteger", "Lit/unibo/tuprolog/core/Integer;", "visitList", "Lit/unibo/tuprolog/core/List;", "visitReal", "Lit/unibo/tuprolog/core/Real;", "visitRule", "Lit/unibo/tuprolog/core/Rule;", "visitStruct", "Lit/unibo/tuprolog/core/Struct;", "visitTruth", "Lit/unibo/tuprolog/core/Truth;", "visitTuple", "Lit/unibo/tuprolog/core/Tuple;", "visitVar", "Lit/unibo/tuprolog/core/Var;", "serialize-core"})
public final class JvmTermObjectifier
implements TermObjectifier {
    @Override
    @NotNull
    public Object defaultValue(@NotNull Term term) {
        Intrinsics.checkNotNullParameter(term, "term");
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Object objectifyMany(@NotNull Iterable<? extends Term> values2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(values2, "values");
        Iterable<? extends Term> $this$map$iv = values2;
        boolean $i$f$map = false;
        Iterable<? extends Term> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Term term = (Term)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = this.objectify((Term)it);
            collection.add(object);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public Map<String, Object> visitVar(@NotNull Var term) {
        Intrinsics.checkNotNullParameter(term, "term");
        return MapsKt.mapOf(TuplesKt.to("var", term.getName()));
    }

    @Override
    @NotNull
    public Object visitTruth(@NotNull Truth term) {
        Intrinsics.checkNotNullParameter(term, "term");
        Truth truth = term;
        return Intrinsics.areEqual(truth, Truth.TRUE) ? (Serializable)Boolean.valueOf(true) : (Intrinsics.areEqual(truth, Truth.FALSE) ? (Serializable)Boolean.valueOf(false) : (Intrinsics.areEqual(truth, Truth.FAIL) ? (Serializable)((Object)"fail") : (Serializable)new NotImplementedError(Intrinsics.stringPlus("Serialization of Truth value: ", term))));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, Object> visitStruct(@NotNull Struct term) {
        Collection collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(term, "term");
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to("fun", term.getFunctor());
        Iterable iterable = term.getArgs();
        String string2 = "args";
        int n = 1;
        Pair[] pairArray2 = pairArray;
        boolean $i$f$map = false;
        void var5_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Term term2 = (Term)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Object t = it.accept(this);
            collection.add(t);
        }
        collection = (List)destination$iv$iv;
        pairArray2[n] = TuplesKt.to(string2, collection);
        return MapsKt.mapOf(pairArray);
    }

    @Override
    @NotNull
    public String visitAtom(@NotNull Atom term) {
        Intrinsics.checkNotNullParameter(term, "term");
        return term.getValue();
    }

    @Override
    @NotNull
    public Object visitInteger(@NotNull Integer term) {
        Object object;
        Intrinsics.checkNotNullParameter(term, "term");
        try {
            object = term.getValue().toLongExact();
        }
        catch (ArithmeticException e) {
            object = MapsKt.mapOf(TuplesKt.to("integer", term.getValue().toString()));
        }
        return object;
    }

    @Override
    @NotNull
    public Object visitReal(@NotNull Real term) {
        Intrinsics.checkNotNullParameter(term, "term");
        return MapsKt.mapOf(TuplesKt.to("real", term.getValue().toString()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, Object> visitBlock(@NotNull Block term) {
        Collection collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(term, "term");
        Iterable iterable = term.toList();
        String string2 = "block";
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Term term2 = (Term)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Object t = it.accept(this);
            collection.add(t);
        }
        collection = (List)destination$iv$iv;
        return MapsKt.mapOf(TuplesKt.to(string2, collection));
    }

    @Override
    @NotNull
    public Map<String, Object> visitEmptyBlock(@NotNull EmptyBlock term) {
        Intrinsics.checkNotNullParameter(term, "term");
        return this.visitBlock(term);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, Object> visitList(@NotNull it.unibo.tuprolog.core.List term) {
        Map<String, Object> map2;
        Intrinsics.checkNotNullParameter(term, "term");
        List<Term> listed = term.toList();
        if (term.isWellFormed()) {
            Collection collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = listed;
            String string2 = "list";
            boolean $i$f$map = false;
            void var5_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Term term2 = (Term)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Object t = it.accept(this);
                collection.add(t);
            }
            collection = (List)destination$iv$iv;
            map2 = MapsKt.mapOf(TuplesKt.to(string2, collection));
        } else {
            Collection collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Pair[] pairArray = new Pair[2];
            Iterable $i$f$map = listed.subList(0, CollectionsKt.getLastIndex(listed));
            String string3 = "list";
            int n = 0;
            Pair[] pairArray2 = pairArray;
            boolean $i$f$map2 = false;
            void destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Term bl = (Term)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                Object t = it.accept(this);
                collection.add(t);
            }
            collection = (List)destination$iv$iv2;
            pairArray2[n] = TuplesKt.to(string3, collection);
            pairArray[1] = TuplesKt.to("tail", listed.get(CollectionsKt.getLastIndex(listed)).accept(this));
            map2 = MapsKt.mapOf(pairArray);
        }
        return map2;
    }

    @Override
    @NotNull
    public Map<String, Object> visitCons(@NotNull Cons term) {
        Intrinsics.checkNotNullParameter(term, "term");
        return this.visitList(term);
    }

    @Override
    @NotNull
    public Map<String, Object> visitEmptyList(@NotNull EmptyList term) {
        Intrinsics.checkNotNullParameter(term, "term");
        return this.visitList(term);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, Object> visitTuple(@NotNull Tuple term) {
        Collection collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(term, "term");
        Iterable iterable = term.toList();
        String string2 = "tuple";
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Term term2 = (Term)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Object t = it.accept(this);
            collection.add(t);
        }
        collection = (List)destination$iv$iv;
        return MapsKt.mapOf(TuplesKt.to(string2, collection));
    }

    @Override
    @NotNull
    public Map<String, Object> visitIndicator(@NotNull Indicator term) {
        Intrinsics.checkNotNullParameter(term, "term");
        Pair[] pairArray = new Pair[]{TuplesKt.to("name", term.getNameTerm().accept(this)), TuplesKt.to("arity", term.getArityTerm().accept(this))};
        return MapsKt.mapOf(pairArray);
    }

    @Override
    @NotNull
    public Map<String, Object> visitRule(@NotNull Rule term) {
        Intrinsics.checkNotNullParameter(term, "term");
        Pair[] pairArray = new Pair[]{TuplesKt.to("head", term.getHead().accept(this)), TuplesKt.to("body", term.getBody().accept(this))};
        return MapsKt.mapOf(pairArray);
    }

    @Override
    @NotNull
    public Map<String, Object> visitFact(@NotNull Fact term) {
        Intrinsics.checkNotNullParameter(term, "term");
        return MapsKt.mapOf(TuplesKt.to("head", term.getHead().accept(this)));
    }

    @Override
    @NotNull
    public Map<String, Object> visitDirective(@NotNull Directive term) {
        Intrinsics.checkNotNullParameter(term, "term");
        return MapsKt.mapOf(TuplesKt.to("body", term.getBody().accept(this)));
    }

    @Override
    @NotNull
    public Object objectifyMany(@NotNull Sequence<? extends Term> values2) {
        return TermObjectifier.DefaultImpls.objectifyMany((TermObjectifier)this, values2);
    }

    @NotNull
    public Object objectifyMany(Term ... values2) {
        return TermObjectifier.DefaultImpls.objectifyMany((TermObjectifier)this, values2);
    }

    @Override
    @NotNull
    public Object objectify(@NotNull Term value) {
        return TermObjectifier.DefaultImpls.objectify(this, value);
    }

    @Override
    @NotNull
    public Object visitClause(@NotNull Clause term) {
        return TermObjectifier.DefaultImpls.visitClause(this, term);
    }

    @Override
    @NotNull
    public Object visitCollection(@NotNull Recursive term) {
        return TermObjectifier.DefaultImpls.visitCollection(this, term);
    }

    @Override
    @NotNull
    public Object visitConstant(@NotNull Constant term) {
        return TermObjectifier.DefaultImpls.visitConstant(this, term);
    }

    @Override
    @NotNull
    public Object visitEmpty(@NotNull Empty term) {
        return TermObjectifier.DefaultImpls.visitEmpty(this, term);
    }

    @Override
    @NotNull
    public Object visitNumeric(@NotNull Numeric term) {
        return TermObjectifier.DefaultImpls.visitNumeric(this, term);
    }

    @Override
    @NotNull
    public Object visitTerm(@NotNull Term term) {
        return TermObjectifier.DefaultImpls.visitTerm(this, term);
    }
}

