/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.serialize;

import com.fasterxml.jackson.databind.ObjectMapper;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.serialize.JvmTermDeobjectifier;
import it.unibo.tuprolog.serialize.MimeType;
import it.unibo.tuprolog.serialize.MimeTypeExtensions;
import it.unibo.tuprolog.serialize.ReadingTermDeserializer;
import java.io.Reader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lit/unibo/tuprolog/serialize/JvmTermDeserializer;", "Lit/unibo/tuprolog/serialize/ReadingTermDeserializer;", "mimeType", "Lit/unibo/tuprolog/serialize/MimeType;", "(Lit/unibo/tuprolog/serialize/MimeType;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMimeType", "()Lit/unibo/tuprolog/serialize/MimeType;", "deserialize", "Lit/unibo/tuprolog/core/Term;", "reader", "Ljava/io/Reader;", "deserializeMany", "", "serialize-core"})
public final class JvmTermDeserializer
implements ReadingTermDeserializer {
    @NotNull
    private final MimeType mimeType;
    @NotNull
    private final ObjectMapper mapper;

    public JvmTermDeserializer(@NotNull MimeType mimeType) {
        Intrinsics.checkNotNullParameter(mimeType, "mimeType");
        this.mimeType = mimeType;
        this.mapper = MimeTypeExtensions.getObjectMapper(this.getMimeType());
    }

    @Override
    @NotNull
    public MimeType getMimeType() {
        return this.mimeType;
    }

    @Override
    @NotNull
    public Term deserialize(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter(reader, "reader");
        JvmTermDeobjectifier jvmTermDeobjectifier = new JvmTermDeobjectifier();
        Object object = this.mapper.readValue(reader, Object.class);
        Intrinsics.checkNotNullExpressionValue(object, "mapper.readValue(reader,\u2026.lang.Object::class.java)");
        return jvmTermDeobjectifier.deobjectify(object);
    }

    @Override
    @NotNull
    public Iterable<Term> deserializeMany(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter(reader, "reader");
        JvmTermDeobjectifier jvmTermDeobjectifier = new JvmTermDeobjectifier();
        Object object = this.mapper.readValue(reader, Object.class);
        Intrinsics.checkNotNullExpressionValue(object, "mapper.readValue(reader,\u2026.lang.Object::class.java)");
        return jvmTermDeobjectifier.deobjectifyMany(object);
    }

    @Override
    @NotNull
    public Term deserialize(@NotNull String string2) {
        return ReadingTermDeserializer.DefaultImpls.deserialize(this, string2);
    }

    @Override
    @NotNull
    public Iterable<Term> deserializeMany(@NotNull String string2) {
        return ReadingTermDeserializer.DefaultImpls.deserializeMany(this, string2);
    }
}

