/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.serialize;

import it.unibo.tuprolog.core.Real;
import it.unibo.tuprolog.core.Scope;
import it.unibo.tuprolog.core.Struct;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.Var;
import it.unibo.tuprolog.serialize.DeobjectificationException;
import it.unibo.tuprolog.serialize.TermDeobjectifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\t\u001a\u00020\u00062\u000e\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00062\u000e\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0002J\u0018\u0010\u0011\u001a\u00020\u00062\u000e\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0002J\u0018\u0010\u0012\u001a\u00020\u00062\u000e\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u0015\u001a\u00020\u00062\u000e\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00062\u000e\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0002J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\rH\u0002J\u0018\u0010\u001a\u001a\u00020\u00062\u000e\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0002J\u0018\u0010\u001b\u001a\u00020\u00062\u000e\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00062\u000e\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lit/unibo/tuprolog/serialize/JvmTermDeobjectifier;", "Lit/unibo/tuprolog/serialize/TermDeobjectifier;", "()V", "scope", "Lit/unibo/tuprolog/core/Scope;", "deobjectify", "Lit/unibo/tuprolog/core/Term;", "object", "", "deobjectifyBlock", "value", "", "name", "", "deobjectifyBoolean", "", "deobjectifyClause", "deobjectifyInteger", "deobjectifyList", "deobjectifyMany", "", "deobjectifyMap", "deobjectifyNumber", "", "deobjectifyReal", "deobjectifyString", "deobjectifyStructure", "deobjectifyTuple", "deobjectifyVariable", "serialize-core"})
public final class JvmTermDeobjectifier
implements TermDeobjectifier {
    @NotNull
    private final Scope scope = Scope.Companion.empty();

    @Override
    @NotNull
    public Term deobjectify(@NotNull Object object) {
        Term term;
        Intrinsics.checkNotNullParameter(object, "object");
        Object object2 = object;
        if (object2 instanceof Boolean) {
            term = this.deobjectifyBoolean((Boolean)object);
        } else if (object2 instanceof Number) {
            term = this.deobjectifyNumber((Number)object);
        } else if (object2 instanceof String) {
            term = this.deobjectifyString((String)object);
        } else if (object2 instanceof Map) {
            term = this.deobjectifyMap((Map)object);
        } else {
            throw new DeobjectificationException(object);
        }
        return term;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<Term> deobjectifyMany(@NotNull Object object) {
        Collection destination$iv$iv;
        Intrinsics.checkNotNullParameter(object, "object");
        Object object2 = object;
        if (object2 instanceof List) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var12_12 = it;
                if (var12_12 == null) {
                    throw new DeobjectificationException(object);
                }
                Term term = this.deobjectify(var12_12);
                collection.add(term);
            }
        } else {
            throw new DeobjectificationException(object);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Term deobjectifyMap(Map<?, ?> value) {
        Term term;
        boolean bl;
        String string2;
        Map<?, ?> map2;
        block23: {
            block22: {
                map2 = value;
                string2 = "var";
                bl = false;
                Map<?, ?> map3 = map2;
                if (map3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
                }
                if (map3.containsKey(string2)) {
                    term = this.deobjectifyVariable(value);
                    return term;
                }
                map2 = value;
                string2 = "fun";
                bl = false;
                Map<?, ?> map4 = map2;
                if (map4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
                }
                if (map4.containsKey(string2)) {
                    map2 = value;
                    string2 = "args";
                    bl = false;
                    Map<?, ?> map5 = map2;
                    if (map5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
                    }
                    if (map5.containsKey(string2)) {
                        term = this.deobjectifyStructure(value);
                        return term;
                    }
                }
                map2 = value;
                string2 = "list";
                bl = false;
                Map<?, ?> map6 = map2;
                if (map6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
                }
                if (map6.containsKey(string2)) {
                    term = this.deobjectifyList(value);
                    return term;
                }
                map2 = value;
                string2 = "block";
                bl = false;
                Map<?, ?> map7 = map2;
                if (map7 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
                }
                if (map7.containsKey(string2)) {
                    term = JvmTermDeobjectifier.deobjectifyBlock$default(this, value, null, 2, null);
                    return term;
                }
                map2 = value;
                string2 = "tuple";
                bl = false;
                Map<?, ?> map8 = map2;
                if (map8 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
                }
                if (map8.containsKey(string2)) {
                    term = this.deobjectifyTuple(value);
                    return term;
                }
                map2 = value;
                string2 = "integer";
                bl = false;
                Map<?, ?> map9 = map2;
                if (map9 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
                }
                if (map9.containsKey(string2)) {
                    term = this.deobjectifyInteger(value);
                    return term;
                }
                map2 = value;
                string2 = "real";
                bl = false;
                Map<?, ?> map10 = map2;
                if (map10 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
                }
                if (map10.containsKey(string2)) {
                    term = this.deobjectifyReal(value);
                    return term;
                }
                map2 = value;
                string2 = "head";
                bl = false;
                Map<?, ?> map11 = map2;
                if (map11 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
                }
                if (map11.containsKey(string2)) break block22;
                map2 = value;
                string2 = "body";
                bl = false;
                Map<?, ?> map12 = map2;
                if (map12 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
                }
                if (!map12.containsKey(string2)) break block23;
            }
            term = this.deobjectifyClause(value);
            return term;
        }
        map2 = value;
        string2 = "set";
        bl = false;
        Map<?, ?> map13 = map2;
        if (map13 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        if (!map13.containsKey(string2)) throw new DeobjectificationException(value);
        term = this.deobjectifyBlock(value, "set");
        return term;
    }

    private final Term deobjectifyReal(Map<?, ?> value) {
        Term term;
        Object object = value;
        Object object2 = "real";
        boolean bl = false;
        Object actualValue = object.get(object2);
        if (actualValue instanceof String) {
            term = this.scope.realOf((String)actualValue);
        } else if (actualValue instanceof Number) {
            object2 = this.deobjectifyNumber((Number)actualValue);
            Object object3 = object = object2 instanceof Real ? (Real)object2 : null;
            if (object == null) {
                throw new DeobjectificationException(value);
            }
            term = (Term)object;
        } else {
            throw new DeobjectificationException(value);
        }
        return term;
    }

    private final Term deobjectifyInteger(Map<?, ?> value) {
        Term term;
        Object object = value;
        Object object2 = "integer";
        boolean bl = false;
        Object actualValue = object.get(object2);
        if (actualValue instanceof String) {
            term = this.scope.intOf((String)actualValue);
        } else if (actualValue instanceof Number) {
            object2 = this.deobjectifyNumber((Number)actualValue);
            Object object3 = object = object2 instanceof it.unibo.tuprolog.core.Integer ? (it.unibo.tuprolog.core.Integer)object2 : null;
            if (object == null) {
                throw new DeobjectificationException(value);
            }
            term = (Term)object;
        } else {
            throw new DeobjectificationException(value);
        }
        return term;
    }

    private final Term deobjectifyClause(Map<?, ?> value) {
        Term term;
        Term term2;
        Struct struct;
        Term[] termArray = value;
        Map<?, ?> map2 = "head";
        boolean bl = false;
        Object obj = termArray.get(map2);
        if (obj == null) {
            struct = null;
        } else {
            Struct struct2;
            termArray = obj;
            boolean bl2 = false;
            bl = false;
            Map<Object, Object> it = termArray;
            boolean bl3 = false;
            Term term3 = this.deobjectify(it);
            Struct struct3 = struct2 = term3 instanceof Struct ? (Struct)term3 : null;
            if (struct2 == null) {
                throw new DeobjectificationException(value);
            }
            struct = struct2;
        }
        Struct head2 = struct;
        map2 = value;
        String string2 = "body";
        boolean bl4 = false;
        termArray = map2.get(string2);
        if (termArray == null) {
            term2 = null;
        } else {
            map2 = termArray;
            boolean bl5 = false;
            bl4 = false;
            Map<?, ?> it = map2;
            boolean bl6 = false;
            term2 = this.deobjectify(it);
        }
        Term body = term2;
        if (body == null) {
            Struct struct4 = head2;
            Intrinsics.checkNotNull(struct4);
            term = this.scope.factOf(struct4);
        } else {
            termArray = new Term[]{body};
            term = this.scope.clauseOf(head2, termArray);
        }
        return term;
    }

    /*
     * WARNING - void declaration
     */
    private final Term deobjectifyList(Map<?, ?> value) {
        Term term;
        Term term2;
        Iterable iterable;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list;
        Object object = value;
        String string2 = "list";
        boolean bl = false;
        Object object2 = object.get(string2);
        List list2 = list = object2 instanceof List ? (List)object2 : null;
        if (list == null) {
            throw new DeobjectificationException(value);
        }
        List items2 = list;
        object2 = value;
        object = "tail";
        boolean bl2 = false;
        Object last2 = object2.get(object);
        object2 = items2;
        Scope scope2 = this.scope;
        boolean $i$f$map = false;
        Object v = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            iterable = destination$iv$iv;
            boolean bl3 = false;
            void var13_21 = it;
            if (var13_21 == null) {
                throw new DeobjectificationException(value);
            }
            term2 = this.deobjectify(var13_21);
            iterable.add(term2);
        }
        iterable = (List)destination$iv$iv;
        Scope scope3 = scope2;
        Iterable iterable2 = iterable;
        Object v2 = last2;
        if (v2 == null) {
            term = null;
        } else {
            void it;
            v = v2;
            boolean bl4 = false;
            boolean bl5 = false;
            iterator2 = v;
            iterable = iterable2;
            scope2 = scope3;
            boolean bl6 = false;
            term2 = this.deobjectify(it);
            scope3 = scope2;
            iterable2 = iterable;
            term = term2;
        }
        object2 = term;
        return scope3.listFrom(iterable2, (Term)(object2 == null ? (Term)this.scope.getEmptyList() : object2));
    }

    /*
     * WARNING - void declaration
     */
    private final Term deobjectifyTuple(Map<?, ?> value) {
        Collection<Term> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable;
        Map<?, ?> map2 = value;
        String string2 = "tuple";
        boolean bl = false;
        Object obj = map2.get(string2);
        List list = iterable = obj instanceof List ? (List)obj : null;
        if (iterable == null) {
            throw new DeobjectificationException(value);
        }
        List items2 = iterable;
        iterable = items2;
        Scope scope2 = this.scope;
        boolean $i$f$map = false;
        map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            collection = destination$iv$iv;
            boolean bl2 = false;
            void var12_14 = it;
            if (var12_14 == null) {
                throw new DeobjectificationException(value);
            }
            Term term = this.deobjectify(var12_14);
            collection.add(term);
        }
        collection = (List)destination$iv$iv;
        return scope2.tupleOf((Iterable<? extends Term>)collection);
    }

    /*
     * WARNING - void declaration
     */
    private final Term deobjectifyBlock(Map<?, ?> value, String name) {
        Collection<Term> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable;
        Map<?, ?> map2 = value;
        boolean bl = false;
        Object obj = map2.get(name);
        List list = iterable = obj instanceof List ? (List)obj : null;
        if (iterable == null) {
            throw new DeobjectificationException(value);
        }
        List items2 = iterable;
        iterable = items2;
        Scope scope2 = this.scope;
        boolean $i$f$map = false;
        map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            collection = destination$iv$iv;
            boolean bl2 = false;
            void var13_16 = it;
            if (var13_16 == null) {
                throw new DeobjectificationException(value);
            }
            Term term = this.deobjectify(var13_16);
            collection.add(term);
        }
        collection = (List)destination$iv$iv;
        return scope2.blockOf((Iterable<? extends Term>)collection);
    }

    static /* synthetic */ Term deobjectifyBlock$default(JvmTermDeobjectifier jvmTermDeobjectifier, Map map2, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "block";
        }
        return jvmTermDeobjectifier.deobjectifyBlock(map2, string2);
    }

    /*
     * WARNING - void declaration
     */
    private final Term deobjectifyStructure(Map<?, ?> value) {
        Collection<Term> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string2;
        Map<Object, Object> map2 = value;
        Object object = "fun";
        boolean bl = false;
        Object object2 = map2.get(object);
        String string3 = string2 = object2 instanceof String ? (String)object2 : null;
        if (string2 == null) {
            throw new DeobjectificationException(value);
        }
        String name = string2;
        object = value;
        String string4 = "args";
        boolean bl2 = false;
        map2 = object.get(string4);
        Iterable<Object> iterable = object2 = map2 instanceof List ? (List)((Object)map2) : null;
        if (object2 == null) {
            throw new DeobjectificationException(value);
        }
        Object args2 = object2;
        object2 = (Iterable)args2;
        String string5 = name;
        Scope scope2 = this.scope;
        boolean $i$f$map = false;
        object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            collection = destination$iv$iv;
            boolean bl3 = false;
            void var13_17 = it;
            if (var13_17 == null) {
                throw new DeobjectificationException(value);
            }
            Term term = this.deobjectify(var13_17);
            collection.add(term);
        }
        collection = (List)destination$iv$iv;
        return scope2.structOf(string5, (List<? extends Term>)collection);
    }

    private final Term deobjectifyVariable(Map<?, ?> value) {
        String string2;
        Map<?, ?> map2 = value;
        String string3 = "var";
        boolean bl = false;
        Object obj = map2.get(string3);
        String string4 = string2 = obj instanceof String ? (String)obj : null;
        if (string2 == null) {
            throw new DeobjectificationException(value);
        }
        String name = string2;
        return Intrinsics.areEqual(name, Var.ANONYMOUS_NAME) ? (Term)this.scope.anonymous() : (Term)this.scope.varOf(name);
    }

    private final Term deobjectifyString(String value) {
        return this.scope.atomOf(value);
    }

    private final Term deobjectifyNumber(Number value) {
        Term term;
        Number number = value;
        if (number instanceof Integer) {
            term = this.scope.numOf(value.intValue());
        } else if (number instanceof Long) {
            term = this.scope.numOf(value.longValue());
        } else if (number instanceof Double) {
            term = this.scope.numOf(value.doubleValue());
        } else if (number instanceof Byte) {
            term = this.scope.numOf(value.byteValue());
        } else if (number instanceof Short) {
            term = this.scope.numOf(value.shortValue());
        } else if (number instanceof Float) {
            term = this.scope.numOf(value.floatValue());
        } else if (number instanceof BigInteger) {
            term = it.unibo.tuprolog.core.Integer.Companion.of(value.toString());
        } else if (number instanceof BigDecimal) {
            term = Real.Companion.of(value.toString());
        } else {
            throw new DeobjectificationException(value);
        }
        return term;
    }

    private final Term deobjectifyBoolean(boolean value) {
        return this.scope.truthOf(value);
    }
}

