/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.parser.dynamic;

import it.unibo.tuprolog.parser.dynamic.StringType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Token;

public abstract class DynamicLexer
extends Lexer {
    private final Set<String> operators = new HashSet<String>();

    public DynamicLexer() {
    }

    public DynamicLexer(CharStream input) {
        super(input);
    }

    public boolean isOperator(Token token) {
        return this.isOperator(token.getText());
    }

    public boolean isOperator(String functor) {
        return this.operators.contains(functor);
    }

    public void addOperators(String operator, String ... operators2) {
        this.operators.add(operator);
        this.operators.addAll(Arrays.asList(operators2));
    }

    public void removeOperators(String operator, String ... operators2) {
        this.operators.remove(operator);
        this.operators.removeAll(Arrays.asList(operators2));
    }

    public void clearOperators() {
        this.operators.clear();
    }

    public Set<String> getOperators() {
        return new HashSet<String>(this.operators);
    }

    public final String substring(String string2, int start2, int end) {
        if (end >= 0) {
            return string2.substring(start2, end);
        }
        return string2.substring(start2, string2.length() + end);
    }

    public final String unquote(String string2) {
        return string2.substring(1, string2.length() - 1);
    }

    public String escapeChar(int repr) {
        switch (repr) {
            case 97: {
                return "\u0007";
            }
            case 98: {
                return "\b";
            }
            case 102: {
                return "\f";
            }
            case 110: {
                return "\n";
            }
            case 114: {
                return "\r";
            }
            case 116: {
                return "\t";
            }
            case 118: {
                return "\u000b";
            }
            case 92: {
                return "\\";
            }
            case 34: {
                return "\"";
            }
            case 96: {
                return "`";
            }
            case 39: {
                return "'";
            }
        }
        return "\\" + (char)repr;
    }

    public String escape(String string2) {
        return this.escape(string2, StringType.SINGLE_QUOTED);
    }

    public String escape(String string2, StringType stringType) {
        Objects.requireNonNull(stringType);
        StringBuilder sb = new StringBuilder(string2.length());
        int last2 = string2.length() - 1;
        for (int i = 0; i <= last2; ++i) {
            int lookahead;
            char currentChar = string2.charAt(i);
            int n = lookahead = i < last2 ? (int)string2.charAt(i + 1) : -1;
            if (currentChar == '\\') {
                if (i == last2) {
                    sb.append('\\');
                    continue;
                }
                if (lookahead == 10) {
                    ++i;
                    continue;
                }
                if (lookahead == 120 || lookahead == 88) {
                    int nextSlashPos = string2.indexOf(92, i + 2);
                    if (nextSlashPos > i && nextSlashPos <= last2) {
                        String hexStr = string2.substring(i + 2, nextSlashPos);
                        try {
                            int hex = Integer.parseInt(hexStr, 16);
                            sb.append((char)hex);
                            i += hexStr.length() + 2;
                        }
                        catch (NumberFormatException e) {
                            sb.append(currentChar);
                        }
                        continue;
                    }
                    sb.append(currentChar);
                    continue;
                }
                if (Character.isDigit(lookahead)) {
                    int nextSlashPos = string2.indexOf(92, i + 1);
                    if (nextSlashPos > i && nextSlashPos <= last2) {
                        String octStr = string2.substring(i + 1, nextSlashPos);
                        try {
                            int oct = Integer.parseInt(octStr, 8);
                            sb.append((char)oct);
                            i += octStr.length() + 1;
                        }
                        catch (NumberFormatException e) {
                            sb.append(currentChar);
                        }
                        continue;
                    }
                    sb.append(currentChar);
                    continue;
                }
                if (i < last2 - 1 && lookahead == 13 && string2.charAt(i + 2) == '\n') {
                    i += 2;
                    continue;
                }
                String escaped = this.escapeChar(lookahead);
                sb.append(escaped);
                ++i;
                continue;
            }
            if (stringType == StringType.DOUBLE_QUOTED && currentChar == '\"' && lookahead == 34 || stringType == StringType.SINGLE_QUOTED && currentChar == '\'' && lookahead == 39) {
                sb.append(currentChar);
                ++i;
                continue;
            }
            sb.append(currentChar);
        }
        return sb.toString();
    }
}

