/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.parse;

import guru.nidi.graphviz.parse.ParserException;
import guru.nidi.graphviz.parse.Position;
import guru.nidi.graphviz.parse.Token;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;

class Lexer {
    private static final Map<String, Integer> KEYWORDS = new HashMap<String, Integer>();
    private static final char CH_EOF = '\uffff';
    private final PushbackReader in;
    private char ch;
    Position pos;

    Lexer(Reader in, String name) throws IOException {
        this.in = new PushbackReader(in);
        this.pos = new Position(name);
        this.readChar();
    }

    Token token() throws IOException {
        Token sym = this.symbol();
        if (sym != null) {
            this.readChar();
            return sym;
        }
        return this.numeralOrIdent();
    }

    @Nullable
    private Token symbol() throws IOException {
        switch (this.ch) {
            case '\uffff': {
                return new Token(0, this.ch);
            }
            case ';': {
                return new Token(1, this.ch);
            }
            case ',': {
                return new Token(2, this.ch);
            }
            case '{': {
                return new Token(3, this.ch);
            }
            case '}': {
                return new Token(4, this.ch);
            }
            case '=': {
                return new Token(5, this.ch);
            }
            case '[': {
                return new Token(6, this.ch);
            }
            case ']': {
                return new Token(7, this.ch);
            }
            case ':': {
                return new Token(8, this.ch);
            }
            case '-': {
                char next2 = this.readRawChar();
                if (next2 == '-') {
                    return new Token(18, "--");
                }
                if (next2 == '>') {
                    return new Token(19, "->");
                }
                this.unread('-', next2);
                return null;
            }
        }
        return null;
    }

    private Token numeralOrIdent() throws IOException {
        if (this.ch == '-' || this.ch == '.' || this.ch >= '0' && this.ch <= '9') {
            return this.numeral();
        }
        return this.ident();
    }

    private Token numeral() throws IOException {
        StringBuilder s = new StringBuilder();
        do {
            s.append(this.ch);
            this.readRawChar();
        } while (this.ch == '.' || this.ch >= '0' && this.ch <= '9');
        this.sync();
        return new Token(16, 2, s.toString());
    }

    private Token ident() throws IOException {
        if (this.ch == '\"') {
            return this.quotedIdent();
        }
        if (this.ch == '<') {
            return this.htmlIdent();
        }
        if (this.isIdentStart()) {
            return this.simpleIdent();
        }
        throw new ParserException(this.pos, "Found unexpected character '" + this.ch + "'");
    }

    private boolean isIdentStart() {
        return this.ch >= 'a' && this.ch <= 'z' || this.ch >= 'A' && this.ch <= 'Z' || this.ch >= '\u0080' && this.ch <= '\u00ff' || this.ch == '_';
    }

    private Token quotedIdent() throws IOException {
        StringBuilder s = new StringBuilder();
        this.readRawChar();
        while (this.ch != '\"' && this.ch != '\uffff') {
            s.append(this.ch);
            this.readRawChar();
            if (this.ch == '\"' && s.charAt(s.length() - 1) == '\\') {
                s.replace(s.length() - 1, s.length(), "\"");
                this.readRawChar();
            }
            if (this.ch != '\n' || s.charAt(s.length() - 1) != '\\') continue;
            s.delete(s.length() - 1, s.length());
            this.readRawChar();
        }
        this.readChar();
        return new Token(16, 3, s.toString());
    }

    private Token htmlIdent() throws IOException {
        StringBuilder s = new StringBuilder();
        int level = 1;
        this.readRawChar();
        level = this.htmlLevel(level, this.ch);
        while ((this.ch != '>' || level > 0) && this.ch != '\uffff') {
            s.append(this.ch);
            this.readRawChar();
            level = this.htmlLevel(level, this.ch);
        }
        this.readChar();
        return new Token(16, 4, s.toString());
    }

    private int htmlLevel(int level, char ch) {
        if (ch == '<') {
            return level + 1;
        }
        if (ch == '>') {
            return level - 1;
        }
        return level;
    }

    private Token simpleIdent() throws IOException {
        StringBuilder s = new StringBuilder();
        do {
            s.append(this.ch);
            this.readRawChar();
        } while ((this.isIdentStart() || this.ch >= '0' && this.ch <= '9') && this.ch != '\uffff');
        this.sync();
        Integer key = KEYWORDS.get(s.toString().toLowerCase(Locale.ENGLISH));
        return key == null ? new Token(16, 1, s.toString()) : new Token((int)key, s.toString());
    }

    private void sync() throws IOException {
        if (this.ch <= ' ' && this.ch != '\uffff') {
            this.readChar();
        }
    }

    private void readChar() throws IOException {
        do {
            this.readRawChar();
            if (this.ch != '/') continue;
            this.readComment();
        } while (this.ch <= ' ' && this.ch != '\uffff');
    }

    private void readComment() throws IOException {
        char next2 = this.readRawChar();
        if (next2 == '/') {
            do {
                this.readRawChar();
            } while (this.ch != '\n' && this.ch != '\uffff');
        } else if (next2 == '*') {
            while (true) {
                this.readRawChar();
                if (this.ch != '*' && this.ch != '\uffff') continue;
                this.readRawChar();
                if (this.ch == '/' || this.ch == '\uffff') break;
            }
            this.readRawChar();
        } else {
            this.unread('/', next2);
        }
    }

    private char readRawChar() throws IOException {
        if (this.ch != '\uffff') {
            this.doReadRawChar();
            if (this.ch == '\n') {
                this.pos.newLine();
                do {
                    this.doReadRawChar();
                } while (this.ch <= ' ');
                if (this.ch == '#') {
                    do {
                        this.doReadRawChar();
                    } while (this.ch != '\n' && this.ch != '\uffff');
                    this.pos.newChar();
                } else {
                    this.unread('\n', this.ch);
                }
            }
        }
        return this.ch;
    }

    private void doReadRawChar() throws IOException {
        this.pos.newChar();
        this.ch = (char)this.in.read();
    }

    private void unread(char before, char next2) throws IOException {
        this.pos.lastChar();
        this.ch = before;
        this.in.unread(next2);
    }

    static {
        KEYWORDS.put("strict", 9);
        KEYWORDS.put("graph", 10);
        KEYWORDS.put("digraph", 11);
        KEYWORDS.put("node", 12);
        KEYWORDS.put("edge", 13);
        KEYWORDS.put("subgraph", 14);
    }
}

