/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.GraphElementFinder;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.Node;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathVariableResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SvgElementFinder {
    private static final DocumentBuilderFactory FACTORY = SvgElementFinder.builderFactory();
    private static final TransformerFactory TRANSFORMER_FACTORY = SvgElementFinder.transformerFactory();
    private static final VariableResolver RESOLVER = new VariableResolver();
    private static final XPath X_PATH = SvgElementFinder.xPath(RESOLVER);
    private static final XPathExpression EXPR_G = SvgElementFinder.pathExpression(X_PATH, "//g");
    private static final XPathExpression EXPR_TITLE = SvgElementFinder.pathExpression(X_PATH, "//title[text()=$var]");
    private static final XPathExpression EXPR_TITLE_OR = SvgElementFinder.pathExpression(X_PATH, "//title[text()=$var or text()=$alt]");
    private static final XPathExpression EXPR_NODE = SvgElementFinder.pathExpression(X_PATH, "//g[contains(@class,'node')]");
    private static final XPathExpression EXPR_EDGE = SvgElementFinder.pathExpression(X_PATH, "//g[contains(@class,'edge')]");
    private static final XPathExpression EXPR_CLUSTER = SvgElementFinder.pathExpression(X_PATH, "//g[contains(@class,'cluster')]");
    protected final Document doc;
    private final boolean hasHeader;

    public static String use(String svg, Consumer<SvgElementFinder> actions) {
        SvgElementFinder finder = new SvgElementFinder(svg);
        actions.accept(finder);
        return finder.getSvg();
    }

    SvgElementFinder(SvgElementFinder finder) {
        this.doc = finder.doc;
        this.hasHeader = finder.hasHeader;
    }

    public SvgElementFinder(String svg) {
        try {
            this.doc = this.builder().parse(new InputSource(new StringReader(svg)));
            this.hasHeader = svg.startsWith("<?xml");
        }
        catch (IOException | SAXException e) {
            throw new AssertionError("Could not read SVG", e);
        }
    }

    public String getSvg() {
        StringWriter sw = new StringWriter();
        try {
            TRANSFORMER_FACTORY.newTransformer().transform(new DOMSource(this.doc), new StreamResult(sw));
            String out2 = sw.toString().replace("xmlns=\"\"", "");
            return this.hasHeader ? out2 : out2.substring(out2.indexOf("?>") + 2);
        }
        catch (TransformerException e) {
            throw new AssertionError("Could not generate string from DOM", e);
        }
    }

    public Element findGraph() {
        return (Element)this.nodeExpr(EXPR_G, "");
    }

    @Nullable
    public Element findNode(Node node) {
        return this.findNode(node.name().toString());
    }

    @Nullable
    public Element findNode(String name) {
        org.w3c.dom.Node title = this.nodeExpr(EXPR_TITLE, name);
        return title == null ? null : (Element)title.getParentNode();
    }

    public List<Element> findNodes() {
        return this.listOf(this.nodeExpr(EXPR_NODE));
    }

    public static String nodeNameOf(Element e) {
        return e.getElementsByTagName("title").item(0).getTextContent();
    }

    @Nullable
    public Element findLink(Link link) {
        return this.findLink(link.from().name().toString(), link.to().name().toString());
    }

    @Nullable
    public Element findLink(String from2, String to) {
        org.w3c.dom.Node title = this.nodeExpr(EXPR_TITLE_OR, from2 + "--" + to);
        return title == null ? null : (Element)title.getParentNode();
    }

    public List<Element> findLinks() {
        return this.listOf(this.nodeExpr(EXPR_EDGE));
    }

    public static List<String> linkedNodeNamesOf(Element e) {
        String name;
        return Arrays.asList(name.split((name = e.getElementsByTagName("title").item(0).getTextContent()).contains("--") ? "--" : "->"));
    }

    @Nullable
    public Element findCluster(Graph cluster) {
        return this.findCluster(cluster.name().toString());
    }

    @Nullable
    public Element findCluster(String name) {
        org.w3c.dom.Node title = this.nodeExpr(EXPR_TITLE, "cluster_" + name);
        return title == null ? null : (Element)title.getParentNode();
    }

    public List<Element> findClusters() {
        return this.listOf(this.nodeExpr(EXPR_CLUSTER));
    }

    public static String clusterNameOf(Element e) {
        return e.getElementsByTagName("title").item(0).getTextContent().substring("cluster_".length());
    }

    public GraphElementFinder fromGraph(Graph g) {
        return this.fromGraph((MutableGraph)((Object)g));
    }

    public GraphElementFinder fromGraph(MutableGraph g) {
        return new GraphElementFinder(this, g);
    }

    @Nullable
    private org.w3c.dom.Node nodeExpr(XPathExpression expr, String var) {
        RESOLVER.set(var);
        try {
            return (org.w3c.dom.Node)expr.evaluate(this.doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new AssertionError("Could not execute XPath", e);
        }
    }

    private NodeList nodeExpr(XPathExpression expr) {
        try {
            return (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new AssertionError("Could not execute XPath", e);
        }
    }

    private List<Element> listOf(NodeList nodes) {
        ArrayList<Element> res = new ArrayList<Element>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            res.add((Element)nodes.item(i));
        }
        return res;
    }

    private static DocumentBuilderFactory builderFactory() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            return factory;
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError("Could not initialize DOM", e);
        }
    }

    private static TransformerFactory transformerFactory() {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            return factory;
        }
        catch (TransformerConfigurationException e) {
            throw new AssertionError("Could not initialize DOM", e);
        }
    }

    private DocumentBuilder builder() {
        try {
            return FACTORY.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError("Could not initialize DOM", e);
        }
    }

    private static XPath xPath(XPathVariableResolver resolver) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setXPathVariableResolver(resolver);
        return xPath;
    }

    private static XPathExpression pathExpression(XPath xPath, String exp) {
        try {
            return xPath.compile(exp);
        }
        catch (XPathExpressionException e) {
            throw new AssertionError("Invalid XPath expression", e);
        }
    }

    private static class VariableResolver
    implements XPathVariableResolver {
        private static final ThreadLocal<String> VAR = new ThreadLocal();

        private VariableResolver() {
        }

        public void set(String value) {
            VAR.set(value);
        }

        @Override
        public Object resolveVariable(QName varName) {
            return varName.getLocalPart().equals("var") ? VAR.get() : VAR.get().replace("--", "->");
        }
    }
}

