/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.attribute.Attributed;
import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.ForLink;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.attribute.MapAttributes;
import guru.nidi.graphviz.model.CreationContext;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableAttributed;
import guru.nidi.graphviz.model.MutableNode;
import guru.nidi.graphviz.model.Node;
import guru.nidi.graphviz.model.Port;
import guru.nidi.graphviz.model.PortSource;
import guru.nidi.graphviz.model.SimpleMutableAttributed;
import java.util.Objects;
import javax.annotation.Nullable;

public final class Link
implements Attributed<Link, ForLink>,
LinkTarget {
    @Nullable
    final LinkSource from;
    final LinkTarget to;
    final MutableAttributed<Link, ForLink> attributes;

    public static Link to(MutableNode node) {
        return Link.to(node.port((String)null));
    }

    public static Link to(Node node) {
        return Link.to(node.port((String)null));
    }

    public static Link to(LinkTarget to) {
        return Link.between((LinkSource)null, to);
    }

    public LinkTarget to() {
        return this.to;
    }

    public static Link between(Port port, LinkTarget to) {
        return Link.between(new PortSource(port), to);
    }

    static Link between(@Nullable LinkSource from2, LinkTarget to) {
        return CreationContext.createLink(from2, to);
    }

    Link(@Nullable LinkSource from2, LinkTarget to, Attributes<? extends ForLink> attributes) {
        this.from = from2;
        this.to = to;
        this.attributes = new SimpleMutableAttributed<Link, ForLink>(this, attributes);
    }

    public Link add(Attributes<? extends ForLink> attrs) {
        this.attributes.add((Attributes<ForLink>)attrs);
        return this;
    }

    @Override
    public Link with(Attributes<? extends ForLink> attrs) {
        Attributes<? extends ForLink> as = attrs.applyTo(this.attributes.copy());
        return new Link(this.from, this.to, as);
    }

    @Override
    public Label name() {
        return Label.of((this.from == null ? "" : this.from.name()) + "--" + this.to.name());
    }

    @Override
    public Attributes<? super ForLink> applyTo(MapAttributes<? super ForLink> attrs) {
        return this.attributes.applyTo(attrs);
    }

    @Override
    public Link linkTo() {
        return this;
    }

    public LinkTarget asLinkTarget() {
        return Link.to(this.from.asLinkTarget());
    }

    @Override
    public LinkSource asLinkSource() {
        return this.to.asLinkSource();
    }

    @Nullable
    public LinkSource from() {
        return this.from;
    }

    public MutableAttributed<Link, ForLink> attrs() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link entries = (Link)o;
        return Objects.equals(this.from, entries.from) && this.to.equals(entries.to) && this.attributes.equals(entries.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to, this.attributes);
    }
}

