/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.EngineResult;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.GraphvizPostProcessor;
import guru.nidi.graphviz.engine.Options;
import guru.nidi.graphviz.engine.ProcessOptions;
import guru.nidi.graphviz.model.SvgSizeAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SvgSizeAdjuster
implements GraphvizPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SvgSizeAdjuster.class);

    SvgSizeAdjuster() {
    }

    @Override
    public EngineResult postProcess(EngineResult result2, Options options2, ProcessOptions procOptions) {
        if (options2.format != Format.SVG && options2.format != Format.SVG_STANDALONE && options2.format != Format.PNG) {
            return result2;
        }
        return result2.mapString(s -> this.doPostProcess((String)s, procOptions, options2.format != Format.SVG_STANDALONE));
    }

    private String doPostProcess(String result2, ProcessOptions procOptions, boolean prefix) {
        String unprefixed = prefix ? SvgSizeAdjuster.withoutPrefix(result2) : result2;
        return SvgSizeAdjuster.pointsToPixels(unprefixed, procOptions.dpi, procOptions.width, procOptions.height, procOptions.scale);
    }

    private static String withoutPrefix(String svg) {
        int pos = svg.indexOf("<svg ");
        return pos < 0 ? svg : svg.substring(pos);
    }

    private static String pointsToPixels(String svg, double dpi, int width, int height, double scale) {
        try {
            SvgSizeAnalyzer analyzer = SvgSizeAnalyzer.svg(svg);
            SvgSizeAdjuster.setSize(analyzer, width, height, scale);
            SvgSizeAdjuster.setScale(analyzer, dpi);
            return analyzer.getSvg();
        }
        catch (IllegalArgumentException e) {
            LOG.warn(e.getMessage());
            return svg;
        }
    }

    private static void setSize(SvgSizeAnalyzer analyzer, int width, int height, double scale) {
        double w = analyzer.getWidth();
        double h = analyzer.getHeight();
        if (width > 0 && height > 0) {
            w = width;
            h = height;
        } else if (width > 0) {
            h *= (double)width / w;
            w = width;
        } else if (height > 0) {
            w *= (double)height / h;
            h = height;
        }
        analyzer.setSize((int)Math.round(w * scale), (int)Math.round(h * scale));
    }

    private static void setScale(SvgSizeAnalyzer analyzer, double dpi) {
        double pixelScale = analyzer.getUnit().equals("px") ? 1.0 : (double)Math.round(10000.0 * dpi / 72.0) / 10000.0;
        double scaleX = analyzer.getScaleX() / pixelScale;
        double scaleY = analyzer.getScaleY() / pixelScale;
        analyzer.setScale(scaleX, scaleY);
    }
}

