/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class StringFunctions {
    private StringFunctions() {
    }

    static String replaceRegex(String src, Pattern pattern, Function<String, String> replacer) {
        Matcher matcher = pattern.matcher(src);
        StringBuilder s = new StringBuilder();
        int last2 = 0;
        while (matcher.find()) {
            String attr = matcher.group(1);
            s.append(src, last2, matcher.start(1));
            s.append(replacer.apply(attr));
            last2 = matcher.end(1);
        }
        return s.append(src.substring(last2)).toString();
    }

    static String escapeJs(String js) {
        return js.replace("\\", "\\\\").replace("'", "\\'").replaceAll("\\R", "\\\\n");
    }

    static String replaceSubSpaces(String s) {
        char[] cs = s.toCharArray();
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] >= ' ' || cs[i] == '\t' || cs[i] == '\r' || cs[i] == '\n') continue;
            cs[i] = 32;
        }
        return new String(cs);
    }

    static String replaceNonWordChars(String s) {
        char[] cs = s.toCharArray();
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] == '.' || cs[i] >= '0' && cs[i] <= '9' || cs[i] >= 'A' && cs[i] <= 'Z' || cs[i] >= 'a' && cs[i] <= 'z') continue;
            cs[i] = 45;
        }
        return new String(cs);
    }
}

