/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.AbstractGraphvizEngine;
import guru.nidi.graphviz.engine.BuiltInRasterizer;
import guru.nidi.graphviz.engine.Engine;
import guru.nidi.graphviz.engine.EngineResult;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.GraphvizException;
import guru.nidi.graphviz.engine.GraphvizLoader;
import guru.nidi.graphviz.engine.MissingDependencyException;
import guru.nidi.graphviz.engine.Options;
import guru.nidi.graphviz.engine.Rasterizer;
import guru.nidi.graphviz.engine.StringFunctions;
import guru.nidi.graphviz.engine.TempFiles;
import guru.nidi.graphviz.service.CommandBuilder;
import guru.nidi.graphviz.service.CommandLineExecutor;
import guru.nidi.graphviz.service.CommandRunner;
import guru.nidi.graphviz.service.SystemUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphvizCmdLineEngine
extends AbstractGraphvizEngine {
    private static final Logger LOG = LoggerFactory.getLogger(GraphvizCmdLineEngine.class);
    static final boolean AVAILABLE = GraphvizLoader.isOnClasspath("org/apache/commons/exec/CommandLine.class");
    @Nullable
    private final String executable;
    private final List<Option> cmdOptions;
    private final String envPath;
    private final CommandRunner cmdRunner;
    @Nullable
    private String outputFilePath;
    @Nullable
    private String outputFileName;

    public GraphvizCmdLineEngine() {
        this(null, Collections.emptyList(), Optional.ofNullable(System.getenv("PATH")).orElse(""), GraphvizCmdLineEngine.runner(GraphvizCmdLineEngine.defaultExecutor()));
    }

    public GraphvizCmdLineEngine(String executable, Option ... options2) {
        this(executable, Arrays.asList(options2), Optional.ofNullable(System.getenv("PATH")).orElse(""), GraphvizCmdLineEngine.runner(GraphvizCmdLineEngine.defaultExecutor()));
    }

    private GraphvizCmdLineEngine(@Nullable String executable, List<Option> options2, String envPath, CommandRunner cmdRunner) {
        super(true);
        this.executable = executable;
        this.cmdOptions = options2;
        this.envPath = envPath;
        this.cmdRunner = cmdRunner;
    }

    public GraphvizCmdLineEngine searchPath(String path2) {
        return new GraphvizCmdLineEngine(this.executable, this.cmdOptions, path2, this.cmdRunner);
    }

    public GraphvizCmdLineEngine executor(CommandLineExecutor executor) {
        return new GraphvizCmdLineEngine(this.executable, this.cmdOptions, this.envPath, GraphvizCmdLineEngine.runner(executor));
    }

    private static CommandRunner runner(CommandLineExecutor executor) {
        return new CommandBuilder().withShellWrapper(true).withCommandExecutor(executor).build();
    }

    private static CommandLineExecutor defaultExecutor() {
        if (!AVAILABLE) {
            throw new MissingDependencyException("Command line engine is not available.", "org.apache.commons:commons-exec");
        }
        return new CommandLineExecutor();
    }

    public GraphvizCmdLineEngine timeout(int amount, TimeUnit unit) {
        return (GraphvizCmdLineEngine)super.timeout(amount, unit);
    }

    @Override
    protected void doInit() {
        this.getEngineExecutable();
    }

    @Override
    public EngineResult execute(String src, Options options2, Rasterizer rasterizer) {
        try {
            Path path2 = TempFiles.tempDir("DotEngine");
            File dotFile = this.getDotFile(path2);
            try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dotFile), StandardCharsets.UTF_8));){
                bw.write(this.preprocessCode(src, options2));
            }
            return this.doExecute(path2, dotFile, options2, rasterizer);
        }
        catch (IOException | InterruptedException e) {
            throw new GraphvizException(e.getMessage(), e);
        }
    }

    private EngineResult doExecute(Path path2, File dotFile, Options options2, Rasterizer rasterizer) throws IOException, InterruptedException {
        List nonMatchingOptions = this.cmdOptions.stream().filter(o -> o instanceof NeatoOption && options2.engine != Engine.NEATO || o instanceof FdpOption && options2.engine != Engine.FDP).collect(Collectors.toList());
        if (!nonMatchingOptions.isEmpty()) {
            LOG.warn("Option(s) '" + nonMatchingOptions.stream().map(o -> o.name).collect(Collectors.joining(", ")) + "' are not supported by engine " + (Object)((Object)options2.engine));
        }
        String simpleFormat = this.simpleFormat(options2.format, rasterizer);
        String command = this.getEngineExecutable() + (options2.yInvert != null && options2.yInvert != false ? " -y" : "") + " -K" + options2.engine.toString().toLowerCase(Locale.ENGLISH) + " -T" + this.completeFormat(options2.format, rasterizer) + " " + this.cmdOptions.stream().map(o -> o.name).collect(Collectors.joining(" ")) + " " + dotFile.getAbsolutePath() + " -ooutfile." + simpleFormat;
        LOG.info("input  file://{}", (Object)SystemUtils.uriPathOf(dotFile));
        this.cmdRunner.exec(command, path2.toFile(), this.timeout, new String[0]);
        Path outFile = path2.resolve("outfile." + simpleFormat);
        LOG.info("output file://{}", (Object)SystemUtils.uriPathOf(outFile.toFile()));
        if (rasterizer instanceof BuiltInRasterizer) {
            return EngineResult.fromFile(outFile.toFile());
        }
        byte[] data2 = Files.readAllBytes(outFile);
        return EngineResult.fromString(new String(data2, StandardCharsets.UTF_8));
    }

    protected String preprocessCode(String src, Options options2) {
        return StringFunctions.replaceRegex(StringFunctions.replaceRegex(src, IMG_SRC, path2 -> options2.image((String)path2).processImagePath((String)path2)), IMAGE_ATTR, path2 -> options2.image((String)path2).processImagePath((String)path2));
    }

    private String getEngineExecutable() {
        if (this.executable != null) {
            if (CommandRunner.isExecutableFile(SystemUtils.pathOf(this.executable)) || CommandRunner.isExecutableFound(this.executable, this.envPath)) {
                return this.executable;
            }
            LOG.warn("Executable '" + this.executable + "' not found directly and not on PATH. Trying with 'dot'.");
        }
        List<String> exes = SystemUtils.executableNames("dot");
        for (String exe : exes) {
            if (!CommandRunner.isExecutableFound(exe, this.envPath)) continue;
            return exe;
        }
        GraphvizException e = new GraphvizException(exes + " command not found");
        e.setStackTrace(new StackTraceElement[0]);
        throw e;
    }

    private String simpleFormat(Format format, Rasterizer rasterizer) {
        return rasterizer instanceof BuiltInRasterizer ? ((BuiltInRasterizer)rasterizer).format : format.vizName;
    }

    private String completeFormat(Format format, Rasterizer rasterizer) {
        if (rasterizer instanceof BuiltInRasterizer) {
            BuiltInRasterizer natRast = (BuiltInRasterizer)rasterizer;
            String f = natRast.format;
            if (natRast.renderer != null) {
                f = f + ":" + natRast.renderer;
            }
            if (natRast.formatter != null) {
                f = f + ":" + natRast.formatter;
            }
            return f;
        }
        return format.vizName;
    }

    private File getDotFile(Path path2) {
        String dotFileName = this.outputFileName == null ? "dotfile.dot" : this.outputFileName + ".dot";
        String baseDir = this.outputFilePath == null ? path2.toString() : this.outputFilePath;
        return new File(baseDir, dotFileName);
    }

    public void setDotOutputFile(String path2, String name) {
        this.outputFilePath = path2;
        this.outputFileName = name;
    }

    public static final class FdpOption
    extends Option {
        public static final FdpOption NO_GRID = new FdpOption("-Lg");
        public static final FdpOption OLD_FORCE = new FdpOption("-LO");

        private FdpOption(String name) {
            super(name);
        }

        public static FdpOption iterations(int n) {
            return new FdpOption("-Ln" + n);
        }

        public static FdpOption unscaledFactor(double v) {
            return new FdpOption("-LU" + v);
        }

        public static FdpOption overlapExpansionFactor(double v) {
            return new FdpOption("-LC" + v);
        }

        public static FdpOption temperature(double v) {
            return new FdpOption("-LT" + v);
        }

        public static FdpOption temperatureFactor(double v) {
            return new FdpOption("-LT*" + v);
        }
    }

    public static final class NeatoOption
    extends Option {
        public static final NeatoOption REDUCE_GRAPH = new NeatoOption("-x");
        public static final NeatoOption NO_LAYOUT_AVOID_OVERLAP = new NeatoOption("-n");
        public static final NeatoOption NO_LAYOUT_ALLOW_OVERLAP = new NeatoOption("-n2");

        private NeatoOption(String name) {
            super(name);
        }
    }

    public static class Option {
        final String name;

        protected Option(String name) {
            this.name = name;
        }
    }
}

