/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.attribute.validate;

import guru.nidi.graphviz.attribute.Named;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class ValidatorMessage {
    public final Severity severity;
    public final String attribute;
    public final String message;
    @Nullable
    public final Position position;
    @Nullable
    public final Location location;

    public static Consumer<ValidatorMessage> loggingConsumer(Logger logger) {
        return msg -> {
            Location loc = msg.location;
            Position pos = msg.position;
            String where = loc != null ? String.format("%s '%1.30s'", loc.type.desc(), loc.name.name()) : (pos != null ? String.format("%s:%s:%s", pos.name, pos.line, pos.column) : "");
            logger.info(String.format("%-5s %s -> '%1.20s' %s", new Object[]{msg.severity, where, msg.attribute, msg.message}));
        };
    }

    ValidatorMessage(Severity severity, String message) {
        this(severity, "", message);
    }

    public ValidatorMessage(Severity severity, String attribute, String message) {
        this(severity, attribute, message, null, null);
    }

    public ValidatorMessage(Severity severity, String attribute, String message, @Nullable Position position, @Nullable Location location) {
        this.severity = severity;
        this.attribute = attribute;
        this.message = message;
        this.position = position;
        this.location = location;
    }

    public ValidatorMessage at(Position position) {
        return new ValidatorMessage(this.severity, this.attribute, this.message, position, this.location);
    }

    public ValidatorMessage at(Location location) {
        return new ValidatorMessage(this.severity, this.attribute, this.message, this.position, location);
    }

    ValidatorMessage attribute(String attribute) {
        return new ValidatorMessage(this.severity, attribute, this.message, this.position, this.location);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidatorMessage that = (ValidatorMessage)o;
        return this.severity == that.severity && this.attribute.equals(that.attribute) && this.message.equals(that.message) && Objects.equals(this.position, that.position) && Objects.equals(this.location, that.location);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.severity, this.attribute, this.message, this.position, this.location});
    }

    public String toString() {
        return (Object)((Object)this.severity) + " " + (this.location == null ? "" : this.location) + (this.position == null ? "" : this.position) + ": '" + this.attribute + "' " + this.message;
    }

    public static class Location {
        public final Type type;
        public final Named name;

        public Location(Type type2, Named name) {
            this.type = type2;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Location location = (Location)o;
            return this.type == location.type && this.name.equals(location.name);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.name});
        }

        public String toString() {
            return "Location{type=" + (Object)((Object)this.type) + ", name=" + this.name.name() + '}';
        }

        public static enum Type {
            NODE,
            LINK,
            GRAPH_ATTRS,
            NODE_ATTRS,
            LINK_ATTRS;


            public String desc() {
                String s = super.toString().toLowerCase(Locale.ENGLISH);
                return s.replace("_", " ") + (s.contains("_") ? " of" : "");
            }
        }
    }

    public static class Position {
        public final String name;
        public final int line;
        public final int column;

        public Position(String name, int line, int column) {
            this.name = name;
            this.line = line;
            this.column = column;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Position position = (Position)o;
            return this.line == position.line && this.column == position.column && this.name.equals(position.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.line, this.column);
        }

        public String toString() {
            return "Position{name='" + this.name + '\'' + ", line=" + this.line + ", column=" + this.column + '}';
        }
    }

    public static enum Severity {
        ERROR,
        WARN,
        INFO;

    }
}

