"use strict";
const assert_1 = require("@aws-cdk/assert");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
module.exports = {
    'Can use addCors() to add a CORS configuration'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        // WHEN
        const bucket = new lib_1.Bucket(stack, 'Bucket');
        bucket.addCorsRule({
            allowedMethods: [lib_1.HttpMethods.GET, lib_1.HttpMethods.HEAD],
            allowedOrigins: ['https://example.com']
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::S3::Bucket', {
            CorsConfiguration: {
                CorsRules: [{
                        AllowedMethods: ['GET', 'HEAD'],
                        AllowedOrigins: ['https://example.com']
                    }]
            }
        }));
        test.done();
    },
    'Bucket with multiple cors configurations'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        // WHEN
        new lib_1.Bucket(stack, 'Bucket', {
            cors: [
                {
                    allowedHeaders: [
                        '*'
                    ],
                    allowedMethods: [
                        lib_1.HttpMethods.GET
                    ],
                    allowedOrigins: [
                        '*'
                    ],
                    exposedHeaders: [
                        'Date'
                    ],
                    id: 'myCORSRuleId1',
                    maxAge: 3600
                },
                {
                    allowedHeaders: [
                        'x-amz-*'
                    ],
                    allowedMethods: [
                        lib_1.HttpMethods.DELETE
                    ],
                    allowedOrigins: [
                        'http://www.example1.com',
                        'http://www.example2.com'
                    ],
                    exposedHeaders: [
                        'Connection',
                        'Server',
                        'Date'
                    ],
                    id: 'myCORSRuleId2',
                    maxAge: 1800
                }
            ]
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::S3::Bucket', {
            CorsConfiguration: {
                CorsRules: [
                    {
                        AllowedHeaders: [
                            '*'
                        ],
                        AllowedMethods: [
                            'GET'
                        ],
                        AllowedOrigins: [
                            '*'
                        ],
                        ExposedHeaders: [
                            'Date'
                        ],
                        Id: 'myCORSRuleId1',
                        MaxAge: 3600
                    },
                    {
                        AllowedHeaders: [
                            'x-amz-*'
                        ],
                        AllowedMethods: [
                            'DELETE'
                        ],
                        AllowedOrigins: [
                            'http://www.example1.com',
                            'http://www.example2.com'
                        ],
                        ExposedHeaders: [
                            'Connection',
                            'Server',
                            'Date'
                        ],
                        Id: 'myCORSRuleId2',
                        MaxAge: 1800
                    }
                ]
            }
        }));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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