import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::AmazonMQ::Broker`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html
 */
export interface CfnBrokerProps {
    /**
     * `AWS::AmazonMQ::Broker.AutoMinorVersionUpgrade`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-autominorversionupgrade
     */
    readonly autoMinorVersionUpgrade: boolean | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.BrokerName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-brokername
     */
    readonly brokerName: string;
    /**
     * `AWS::AmazonMQ::Broker.DeploymentMode`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-deploymentmode
     */
    readonly deploymentMode: string;
    /**
     * `AWS::AmazonMQ::Broker.EngineType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-enginetype
     */
    readonly engineType: string;
    /**
     * `AWS::AmazonMQ::Broker.EngineVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-engineversion
     */
    readonly engineVersion: string;
    /**
     * `AWS::AmazonMQ::Broker.HostInstanceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-hostinstancetype
     */
    readonly hostInstanceType: string;
    /**
     * `AWS::AmazonMQ::Broker.PubliclyAccessible`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-publiclyaccessible
     */
    readonly publiclyAccessible: boolean | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.Users`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-users
     */
    readonly users: Array<CfnBroker.UserProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.AuthenticationStrategy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-authenticationstrategy
     */
    readonly authenticationStrategy?: string;
    /**
     * `AWS::AmazonMQ::Broker.Configuration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-configuration
     */
    readonly configuration?: CfnBroker.ConfigurationIdProperty | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.EncryptionOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-encryptionoptions
     */
    readonly encryptionOptions?: CfnBroker.EncryptionOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.LdapMetadata`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-ldapmetadata
     */
    readonly ldapMetadata?: CfnBroker.LdapMetadataProperty | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.LdapServerMetadata`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-ldapservermetadata
     */
    readonly ldapServerMetadata?: CfnBroker.LdapServerMetadataProperty | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.Logs`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-logs
     */
    readonly logs?: CfnBroker.LogListProperty | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.MaintenanceWindowStartTime`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-maintenancewindowstarttime
     */
    readonly maintenanceWindowStartTime?: CfnBroker.MaintenanceWindowProperty | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.SecurityGroups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-securitygroups
     */
    readonly securityGroups?: string[];
    /**
     * `AWS::AmazonMQ::Broker.StorageType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-storagetype
     */
    readonly storageType?: string;
    /**
     * `AWS::AmazonMQ::Broker.SubnetIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-subnetids
     */
    readonly subnetIds?: string[];
    /**
     * `AWS::AmazonMQ::Broker.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-tags
     */
    readonly tags?: CfnBroker.TagsEntryProperty[];
}
/**
 * A CloudFormation `AWS::AmazonMQ::Broker`
 *
 * @cloudformationResource AWS::AmazonMQ::Broker
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html
 */
export declare class CfnBroker extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AmazonMQ::Broker";
    /**
     * @cloudformationAttribute AmqpEndpoints
     */
    readonly attrAmqpEndpoints: string[];
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute ConfigurationId
     */
    readonly attrConfigurationId: string;
    /**
     * @cloudformationAttribute ConfigurationRevision
     */
    readonly attrConfigurationRevision: number;
    /**
     * @cloudformationAttribute IpAddresses
     */
    readonly attrIpAddresses: string[];
    /**
     * @cloudformationAttribute MqttEndpoints
     */
    readonly attrMqttEndpoints: string[];
    /**
     * @cloudformationAttribute OpenWireEndpoints
     */
    readonly attrOpenWireEndpoints: string[];
    /**
     * @cloudformationAttribute StompEndpoints
     */
    readonly attrStompEndpoints: string[];
    /**
     * @cloudformationAttribute WssEndpoints
     */
    readonly attrWssEndpoints: string[];
    /**
     * `AWS::AmazonMQ::Broker.AutoMinorVersionUpgrade`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-autominorversionupgrade
     */
    autoMinorVersionUpgrade: boolean | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.BrokerName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-brokername
     */
    brokerName: string;
    /**
     * `AWS::AmazonMQ::Broker.DeploymentMode`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-deploymentmode
     */
    deploymentMode: string;
    /**
     * `AWS::AmazonMQ::Broker.EngineType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-enginetype
     */
    engineType: string;
    /**
     * `AWS::AmazonMQ::Broker.EngineVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-engineversion
     */
    engineVersion: string;
    /**
     * `AWS::AmazonMQ::Broker.HostInstanceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-hostinstancetype
     */
    hostInstanceType: string;
    /**
     * `AWS::AmazonMQ::Broker.PubliclyAccessible`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-publiclyaccessible
     */
    publiclyAccessible: boolean | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.Users`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-users
     */
    users: Array<CfnBroker.UserProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.AuthenticationStrategy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-authenticationstrategy
     */
    authenticationStrategy: string | undefined;
    /**
     * `AWS::AmazonMQ::Broker.Configuration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-configuration
     */
    configuration: CfnBroker.ConfigurationIdProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AmazonMQ::Broker.EncryptionOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-encryptionoptions
     */
    encryptionOptions: CfnBroker.EncryptionOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AmazonMQ::Broker.LdapMetadata`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-ldapmetadata
     */
    ldapMetadata: CfnBroker.LdapMetadataProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AmazonMQ::Broker.LdapServerMetadata`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-ldapservermetadata
     */
    ldapServerMetadata: CfnBroker.LdapServerMetadataProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AmazonMQ::Broker.Logs`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-logs
     */
    logs: CfnBroker.LogListProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AmazonMQ::Broker.MaintenanceWindowStartTime`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-maintenancewindowstarttime
     */
    maintenanceWindowStartTime: CfnBroker.MaintenanceWindowProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AmazonMQ::Broker.SecurityGroups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-securitygroups
     */
    securityGroups: string[] | undefined;
    /**
     * `AWS::AmazonMQ::Broker.StorageType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-storagetype
     */
    storageType: string | undefined;
    /**
     * `AWS::AmazonMQ::Broker.SubnetIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-subnetids
     */
    subnetIds: string[] | undefined;
    /**
     * `AWS::AmazonMQ::Broker.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::AmazonMQ::Broker`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnBrokerProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnBroker {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-configurationid.html
     */
    interface ConfigurationIdProperty {
        /**
         * `CfnBroker.ConfigurationIdProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-configurationid.html#cfn-amazonmq-broker-configurationid-id
         */
        readonly id: string;
        /**
         * `CfnBroker.ConfigurationIdProperty.Revision`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-configurationid.html#cfn-amazonmq-broker-configurationid-revision
         */
        readonly revision: number;
    }
}
export declare namespace CfnBroker {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-encryptionoptions.html
     */
    interface EncryptionOptionsProperty {
        /**
         * `CfnBroker.EncryptionOptionsProperty.KmsKeyId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-encryptionoptions.html#cfn-amazonmq-broker-encryptionoptions-kmskeyid
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnBroker.EncryptionOptionsProperty.UseAwsOwnedKey`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-encryptionoptions.html#cfn-amazonmq-broker-encryptionoptions-useawsownedkey
         */
        readonly useAwsOwnedKey: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnBroker {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-interbrokercred.html
     */
    interface InterBrokerCredProperty {
        /**
         * `CfnBroker.InterBrokerCredProperty.Password`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-interbrokercred.html#cfn-amazonmq-broker-interbrokercred-password
         */
        readonly password: string;
        /**
         * `CfnBroker.InterBrokerCredProperty.Username`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-interbrokercred.html#cfn-amazonmq-broker-interbrokercred-username
         */
        readonly username: string;
    }
}
export declare namespace CfnBroker {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapmetadata.html
     */
    interface LdapMetadataProperty {
        /**
         * `CfnBroker.LdapMetadataProperty.InterBrokerCreds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapmetadata.html#cfn-amazonmq-broker-ldapmetadata-interbrokercreds
         */
        readonly interBrokerCreds?: Array<CfnBroker.InterBrokerCredProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnBroker.LdapMetadataProperty.ServerMetadata`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapmetadata.html#cfn-amazonmq-broker-ldapmetadata-servermetadata
         */
        readonly serverMetadata: CfnBroker.ServerMetadataProperty | cdk.IResolvable;
    }
}
export declare namespace CfnBroker {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html
     */
    interface LdapServerMetadataProperty {
        /**
         * `CfnBroker.LdapServerMetadataProperty.Hosts`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-hosts
         */
        readonly hosts: string[];
        /**
         * `CfnBroker.LdapServerMetadataProperty.RoleBase`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-rolebase
         */
        readonly roleBase: string;
        /**
         * `CfnBroker.LdapServerMetadataProperty.RoleName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-rolename
         */
        readonly roleName?: string;
        /**
         * `CfnBroker.LdapServerMetadataProperty.RoleSearchMatching`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-rolesearchmatching
         */
        readonly roleSearchMatching: string;
        /**
         * `CfnBroker.LdapServerMetadataProperty.RoleSearchSubtree`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-rolesearchsubtree
         */
        readonly roleSearchSubtree?: boolean | cdk.IResolvable;
        /**
         * `CfnBroker.LdapServerMetadataProperty.ServiceAccountPassword`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-serviceaccountpassword
         */
        readonly serviceAccountPassword: string;
        /**
         * `CfnBroker.LdapServerMetadataProperty.ServiceAccountUsername`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-serviceaccountusername
         */
        readonly serviceAccountUsername: string;
        /**
         * `CfnBroker.LdapServerMetadataProperty.UserBase`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-userbase
         */
        readonly userBase: string;
        /**
         * `CfnBroker.LdapServerMetadataProperty.UserRoleName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-userrolename
         */
        readonly userRoleName?: string;
        /**
         * `CfnBroker.LdapServerMetadataProperty.UserSearchMatching`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-usersearchmatching
         */
        readonly userSearchMatching: string;
        /**
         * `CfnBroker.LdapServerMetadataProperty.UserSearchSubtree`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-usersearchsubtree
         */
        readonly userSearchSubtree?: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnBroker {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-loglist.html
     */
    interface LogListProperty {
        /**
         * `CfnBroker.LogListProperty.Audit`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-loglist.html#cfn-amazonmq-broker-loglist-audit
         */
        readonly audit?: boolean | cdk.IResolvable;
        /**
         * `CfnBroker.LogListProperty.General`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-loglist.html#cfn-amazonmq-broker-loglist-general
         */
        readonly general?: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnBroker {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-maintenancewindow.html
     */
    interface MaintenanceWindowProperty {
        /**
         * `CfnBroker.MaintenanceWindowProperty.DayOfWeek`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-maintenancewindow.html#cfn-amazonmq-broker-maintenancewindow-dayofweek
         */
        readonly dayOfWeek: string;
        /**
         * `CfnBroker.MaintenanceWindowProperty.TimeOfDay`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-maintenancewindow.html#cfn-amazonmq-broker-maintenancewindow-timeofday
         */
        readonly timeOfDay: string;
        /**
         * `CfnBroker.MaintenanceWindowProperty.TimeZone`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-maintenancewindow.html#cfn-amazonmq-broker-maintenancewindow-timezone
         */
        readonly timeZone: string;
    }
}
export declare namespace CfnBroker {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-servermetadata.html
     */
    interface ServerMetadataProperty {
        /**
         * `CfnBroker.ServerMetadataProperty.Hosts`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-servermetadata.html#cfn-amazonmq-broker-servermetadata-hosts
         */
        readonly hosts: string[];
        /**
         * `CfnBroker.ServerMetadataProperty.RoleBase`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-servermetadata.html#cfn-amazonmq-broker-servermetadata-rolebase
         */
        readonly roleBase: string;
        /**
         * `CfnBroker.ServerMetadataProperty.RoleName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-servermetadata.html#cfn-amazonmq-broker-servermetadata-rolename
         */
        readonly roleName?: string;
        /**
         * `CfnBroker.ServerMetadataProperty.RoleSearchMatching`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-servermetadata.html#cfn-amazonmq-broker-servermetadata-rolesearchmatching
         */
        readonly roleSearchMatching: string;
        /**
         * `CfnBroker.ServerMetadataProperty.RoleSearchSubtree`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-servermetadata.html#cfn-amazonmq-broker-servermetadata-rolesearchsubtree
         */
        readonly roleSearchSubtree?: boolean | cdk.IResolvable;
        /**
         * `CfnBroker.ServerMetadataProperty.ServiceAccountPassword`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-servermetadata.html#cfn-amazonmq-broker-servermetadata-serviceaccountpassword
         */
        readonly serviceAccountPassword: string;
        /**
         * `CfnBroker.ServerMetadataProperty.ServiceAccountUsername`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-servermetadata.html#cfn-amazonmq-broker-servermetadata-serviceaccountusername
         */
        readonly serviceAccountUsername: string;
        /**
         * `CfnBroker.ServerMetadataProperty.UserBase`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-servermetadata.html#cfn-amazonmq-broker-servermetadata-userbase
         */
        readonly userBase: string;
        /**
         * `CfnBroker.ServerMetadataProperty.UserRoleName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-servermetadata.html#cfn-amazonmq-broker-servermetadata-userrolename
         */
        readonly userRoleName?: string;
        /**
         * `CfnBroker.ServerMetadataProperty.UserSearchMatching`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-servermetadata.html#cfn-amazonmq-broker-servermetadata-usersearchmatching
         */
        readonly userSearchMatching: string;
        /**
         * `CfnBroker.ServerMetadataProperty.UserSearchSubtree`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-servermetadata.html#cfn-amazonmq-broker-servermetadata-usersearchsubtree
         */
        readonly userSearchSubtree?: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnBroker {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-tagsentry.html
     */
    interface TagsEntryProperty {
        /**
         * `CfnBroker.TagsEntryProperty.Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-tagsentry.html#cfn-amazonmq-broker-tagsentry-key
         */
        readonly key: string;
        /**
         * `CfnBroker.TagsEntryProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-tagsentry.html#cfn-amazonmq-broker-tagsentry-value
         */
        readonly value: string;
    }
}
export declare namespace CfnBroker {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html
     */
    interface UserProperty {
        /**
         * `CfnBroker.UserProperty.ConsoleAccess`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html#cfn-amazonmq-broker-user-consoleaccess
         */
        readonly consoleAccess?: boolean | cdk.IResolvable;
        /**
         * `CfnBroker.UserProperty.Groups`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html#cfn-amazonmq-broker-user-groups
         */
        readonly groups?: string[];
        /**
         * `CfnBroker.UserProperty.Password`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html#cfn-amazonmq-broker-user-password
         */
        readonly password: string;
        /**
         * `CfnBroker.UserProperty.Username`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html#cfn-amazonmq-broker-user-username
         */
        readonly username: string;
    }
}
/**
 * Properties for defining a `AWS::AmazonMQ::Configuration`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html
 */
export interface CfnConfigurationProps {
    /**
     * `AWS::AmazonMQ::Configuration.Data`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-data
     */
    readonly data: string;
    /**
     * `AWS::AmazonMQ::Configuration.EngineType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-enginetype
     */
    readonly engineType: string;
    /**
     * `AWS::AmazonMQ::Configuration.EngineVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-engineversion
     */
    readonly engineVersion: string;
    /**
     * `AWS::AmazonMQ::Configuration.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-name
     */
    readonly name: string;
    /**
     * `AWS::AmazonMQ::Configuration.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-description
     */
    readonly description?: string;
    /**
     * `AWS::AmazonMQ::Configuration.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-tags
     */
    readonly tags?: CfnConfiguration.TagsEntryProperty[];
}
/**
 * A CloudFormation `AWS::AmazonMQ::Configuration`
 *
 * @cloudformationResource AWS::AmazonMQ::Configuration
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html
 */
export declare class CfnConfiguration extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AmazonMQ::Configuration";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @cloudformationAttribute Revision
     */
    readonly attrRevision: number;
    /**
     * `AWS::AmazonMQ::Configuration.Data`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-data
     */
    data: string;
    /**
     * `AWS::AmazonMQ::Configuration.EngineType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-enginetype
     */
    engineType: string;
    /**
     * `AWS::AmazonMQ::Configuration.EngineVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-engineversion
     */
    engineVersion: string;
    /**
     * `AWS::AmazonMQ::Configuration.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-name
     */
    name: string;
    /**
     * `AWS::AmazonMQ::Configuration.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-description
     */
    description: string | undefined;
    /**
     * `AWS::AmazonMQ::Configuration.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::AmazonMQ::Configuration`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConfigurationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnConfiguration {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-configuration-tagsentry.html
     */
    interface TagsEntryProperty {
        /**
         * `CfnConfiguration.TagsEntryProperty.Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-configuration-tagsentry.html#cfn-amazonmq-configuration-tagsentry-key
         */
        readonly key: string;
        /**
         * `CfnConfiguration.TagsEntryProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-configuration-tagsentry.html#cfn-amazonmq-configuration-tagsentry-value
         */
        readonly value: string;
    }
}
/**
 * Properties for defining a `AWS::AmazonMQ::ConfigurationAssociation`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configurationassociation.html
 */
export interface CfnConfigurationAssociationProps {
    /**
     * `AWS::AmazonMQ::ConfigurationAssociation.Broker`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configurationassociation.html#cfn-amazonmq-configurationassociation-broker
     */
    readonly broker: string;
    /**
     * `AWS::AmazonMQ::ConfigurationAssociation.Configuration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configurationassociation.html#cfn-amazonmq-configurationassociation-configuration
     */
    readonly configuration: CfnConfigurationAssociation.ConfigurationIdProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::AmazonMQ::ConfigurationAssociation`
 *
 * @cloudformationResource AWS::AmazonMQ::ConfigurationAssociation
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configurationassociation.html
 */
export declare class CfnConfigurationAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AmazonMQ::ConfigurationAssociation";
    /**
     * `AWS::AmazonMQ::ConfigurationAssociation.Broker`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configurationassociation.html#cfn-amazonmq-configurationassociation-broker
     */
    broker: string;
    /**
     * `AWS::AmazonMQ::ConfigurationAssociation.Configuration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configurationassociation.html#cfn-amazonmq-configurationassociation-configuration
     */
    configuration: CfnConfigurationAssociation.ConfigurationIdProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::AmazonMQ::ConfigurationAssociation`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConfigurationAssociationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnConfigurationAssociation {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-configurationassociation-configurationid.html
     */
    interface ConfigurationIdProperty {
        /**
         * `CfnConfigurationAssociation.ConfigurationIdProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-configurationassociation-configurationid.html#cfn-amazonmq-configurationassociation-configurationid-id
         */
        readonly id: string;
        /**
         * `CfnConfigurationAssociation.ConfigurationIdProperty.Revision`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-configurationassociation-configurationid.html#cfn-amazonmq-configurationassociation-configurationid-revision
         */
        readonly revision: number;
    }
}
