# Acclimatise

Acclimatise is a Python library and command-line utility for parsing the help output
of a command-line tool and then outputting a description of the tool in a more
structured format, for example a
[Common Workflow Language tool definition](https://www.commonwl.org/v1.1/CommandLineTool.html).

Currently Acclamitise supports both [CWL](https://www.commonwl.org/) and
[WDL](https://openwdl.org/) outputs, but other formats will be considered in the future, especially pull
requests to support them.

## Example

Lets say you want to create a CWL workflow containing the common Unix `wc` (word count)
utility. Running `wc --help` returns:

```
Usage: wc [OPTION]... [FILE]...
  or: wc [OPTION]... --files0-from=F
Print newline, word, and byte counts for each FILE, and a total line if
more than one FILE is specified.  A word is a non-zero-length sequence of
characters delimited by white space.

With no FILE, or when FILE is -, read standard input.

The options below may be used to select which counts are printed, always in
the following order: newline, word, character, byte, maximum line length.
  -c, --bytes            print the byte counts
  -m, --chars            print the character counts
  -l, --lines            print the newline counts
      --files0-from=F    read input from the files specified by
                           NUL-terminated names in file F;
                           If F is - then read names from standard input
  -L, --max-line-length  print the maximum display width
  -w, --words            print the word counts
      --help display this help and exit
      --version output version information and exit

GNU coreutils online help: <http://www.gnu.org/software/coreutils/>
Full documentation at: <http://www.gnu.org/software/coreutils/wc>
or available locally via: info '(coreutils) wc invocation'
```

If you run `acclimatise -f wdl wc`, which means "convert the wc command into wdl",
you'll get the following output:

```wdl
version 1.0

task Wc {
  input {
    Boolean bytesBytes
    Boolean charsChars
    Boolean linesLines
    String filesFiles0From
    Boolean maxMaxLineLength
    Boolean wordsWords
    String? orOr
  }
  command <<<
    wc \
      ~{orOr} \
      ~{true="--bytes" false="" bytesBytes} \
      ~{true="--chars" false="" charsChars} \
      ~{true="--lines" false="" linesLines} \
      ~{if defined(filesFiles0From) then ("--files0-from " +  '"' + filesFiles0From + '"') else ""} \
      ~{true="--max-line-length" false="" maxMaxLineLength} \
      ~{true="--words" false="" wordsWords}
  >>>
}
```
