"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const fs = require("fs");
const bundling_1 = require("../lib/bundling");
jest.mock('@aws-cdk/aws-lambda');
const writeFileSyncMock = jest.spyOn(fs, 'writeFileSync');
beforeEach(() => {
    jest.clearAllMocks();
});
test('Parcel bundling', () => {
    bundling_1.Bundling.parcel({
        entry: '/project/folder/entry.ts',
        global: 'handler',
        cacheDir: '/cache-dir',
        nodeDockerTag: 'lts-alpine',
        nodeVersion: '12',
        projectRoot: '/project',
        environment: {
            KEY: 'value',
        },
    });
    // Correctly bundles with parcel
    expect(aws_lambda_1.Code.fromAsset).toHaveBeenCalledWith('/project', {
        assetHashType: core_1.AssetHashType.BUNDLE,
        bundling: expect.objectContaining({
            environment: {
                KEY: 'value',
            },
            volumes: [{ containerPath: '/parcel-cache', hostPath: '/cache-dir' }],
            workingDirectory: '/asset-input/folder',
            command: [
                'parcel', 'build', '/asset-input/folder/entry.ts',
                '--out-dir', '/asset-output',
                '--out-file', 'index.js',
                '--global', 'handler',
                '--target', 'node',
                '--bundle-node-modules',
                '--log-level', '2',
                '--no-minify',
                '--no-source-maps',
                '--cache-dir', '/parcel-cache',
            ],
        }),
    });
    // Correctly updates package.json
    expect(writeFileSyncMock).toHaveBeenCalledWith(expect.stringContaining('package.json'), expect.stringContaining('"node": ">= 12"'));
});
test('Parcel with Windows paths', () => {
    bundling_1.Bundling.parcel({
        entry: 'C:\\my-project\\lib\\entry.ts',
        global: 'handler',
        cacheDir: '/cache-dir',
        nodeDockerTag: 'lts-alpine',
        nodeVersion: '12',
        projectRoot: 'C:\\my-project',
    });
    expect(aws_lambda_1.Code.fromAsset).toHaveBeenCalledWith('C:\\my-project', expect.objectContaining({
        bundling: expect.objectContaining({
            command: expect.arrayContaining([
                'parcel', 'build', expect.stringContaining('/lib/entry.ts'),
            ]),
        }),
    }));
});
//# sourceMappingURL=data:application/json;base64,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