
ARC (Alkali Rydberg Calculator)
===============================


ARC (Alkali Rydberg Calculator)  is package of routines written in Python, using object-oriented programming (OOP) to make modular, reusable and extendable collection of routines and data for performing useful calculations of single atom and two-atom properties, like level diagrams, interactions and transition strengths for alkali metal atoms.

Start by installing the latest version of the ARC package calling Python pip ([see prerequisites](https://arc-alkali-rydberg-calculator.readthedocs.io/en/latest/installation.html)) from the command line:

```pip install ARC-Alkali-Rydberg-Calculator ```

For documentation see [online documentation on Read The Docs](http://arc-alkali-rydberg-calculator.readthedocs.io). 

For examples of use check [IPython example notebooks](https://arc-alkali-rydberg-calculator.readthedocs.io/en/latest/getting_started.html#ipython-notebook-with-examples).

For online access to a selection of package functions see [online Atom Calculator](https://atomcalc.jqc.org.uk).

If you want to contribute to the project, [check this page](https://arc-alkali-rydberg-calculator.readthedocs.io/en/latest/contribute.html).

![Documentation Status](https://readthedocs.org/projects/arc-alkali-rydberg-calculator/badge/?version=latest) [![Build Status](https://travis-ci.org/nikolasibalic/ARC-Alkali-Rydberg-Calculator.svg?branch=master)](https://travis-ci.org/nikolasibalic/ARC-Alkali-Rydberg-Calculator) [![Build status](https://ci.appveyor.com/api/projects/status/oerrwe9otd96es4h/branch/master?svg=true)](https://ci.appveyor.com/project/nikolasibalic/arc-alkali-rydberg-calculator/branch/master) [![Language grade: Python](https://img.shields.io/lgtm/grade/python/g/nikolasibalic/ARC-Alkali-Rydberg-Calculator.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/nikolasibalic/ARC-Alkali-Rydberg-Calculator/context:python) [![PyPI version](https://badge.fury.io/py/ARC-Alkali-Rydberg-Calculator.svg)](https://badge.fury.io/py/ARC-Alkali-Rydberg-Calculator)  [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/nikolasibalic/ARC-Alkali-Rydberg-Calculator.git/master?urlpath=lab%2Ftree%2Fdoc%2FRydberg_atoms_a_primer_notebook.ipynb)

-------
Authors
-------

[Nikola Šibalić](https://github.com/nikolasibalic), [Jonathan D. Pritchard](http://photonics.phys.strath.ac.uk/people/dr-jonathan-pritchard/), [Charles S. Adams](https://www.dur.ac.uk/physics/staff/profiles/?id=523), [Kevin J. Weatherill](https://www.dur.ac.uk/physics/staff/profiles/?id=1882)

**Please cite as:** N. Šibalić, J. D. Pritchard, K. J. Weatherill, C. S. Adams,
ARC: An open-source library for calculating properties of alkali Rydberg atoms,
*Computer Physics Communications* **220**, 319 (2017), [https://doi.org/10.1016/j.cpc.2017.06.015](https://doi.org/10.1016/j.cpc.2017.06.015)

If you are using modules from `arc.advanced` please **also cite** [paper](arc/advanced/README.md) that introduced relevant ARC extension.

**Who are the users of this library?** Check papers that cite us in [ADS](https://ui.adsabs.harvard.edu/abs/2017CoPhC.220..319S/citations) and [Google Scholar](https://scholar.google.com/scholar?cites=17451096747440945721&as_sdt=2005&sciodt=0,5&hl=en).

-------
License
-------

All the files distributed with this program are provided subject to the
BSD-3-Clause license. A copy of the license is provided.
