"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3ToStepfunctions = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("@aws-solutions-constructs/core");
const aws_eventbridge_stepfunctions_1 = require("@aws-solutions-constructs/aws-eventbridge-stepfunctions");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
class S3ToStepfunctions extends constructs_1.Construct {
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the S3ToStepfunctions class.
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        let bucket;
        if (props.deployCloudTrail !== undefined) {
            defaults.printWarning("The deployCloudTrail prop has been deprecated since this construct no longer requires \
      AWS CloudTrail to implement its functionality. This construct no longer creates a CloudTrail in your account.");
        }
        if (!props.existingBucketObj) {
            [this.s3Bucket, this.s3LoggingBucket] = defaults.buildS3Bucket(this, {
                bucketProps: props.bucketProps,
                loggingBucketProps: props.loggingBucketProps,
                logS3AccessLogs: props.logS3AccessLogs
            });
            bucket = this.s3Bucket;
            const cfnBucket = bucket.node.defaultChild;
            cfnBucket.addPropertyOverride('NotificationConfiguration.EventBridgeConfiguration.EventBridgeEnabled', true);
        }
        else {
            bucket = props.existingBucketObj;
        }
        this.s3BucketInterface = bucket;
        let _eventRuleProps = {};
        if (props.eventRuleProps) {
            _eventRuleProps = props.eventRuleProps;
        }
        else {
            // By default the EventBridge Rule will filter any PutObject, POST Object, CopyObject,
            // or CompleteMultipartUpload events for the S3 Bucket
            _eventRuleProps = {
                eventPattern: {
                    source: ['aws.s3'],
                    detailType: ["Object Created"],
                    detail: {
                        bucket: {
                            name: [bucket.bucketName]
                        }
                    }
                }
            };
        }
        const eventbridgeToStepfunctions = new aws_eventbridge_stepfunctions_1.EventbridgeToStepfunctions(this, `${id}-event-rule-step-function-construct`, {
            stateMachineProps: props.stateMachineProps,
            eventRuleProps: _eventRuleProps,
            createCloudWatchAlarms: props.createCloudWatchAlarms,
            logGroupProps: props.logGroupProps
        });
        this.stateMachine = eventbridgeToStepfunctions.stateMachine;
        this.stateMachineLogGroup = eventbridgeToStepfunctions.stateMachineLogGroup;
        this.cloudwatchAlarms = eventbridgeToStepfunctions.cloudwatchAlarms;
    }
}
exports.S3ToStepfunctions = S3ToStepfunctions;
_a = JSII_RTTI_SYMBOL_1;
S3ToStepfunctions[_a] = { fqn: "@aws-solutions-constructs/aws-s3-stepfunctions.S3ToStepfunctions", version: "2.2.0" };
//# sourceMappingURL=data:application/json;base64,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