import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::IoTSiteWise::AccessPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-accesspolicy.html
 * @external
 */
export interface CfnAccessPolicyProps {
    /**
     * `AWS::IoTSiteWise::AccessPolicy.AccessPolicyIdentity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-accesspolicy.html#cfn-iotsitewise-accesspolicy-accesspolicyidentity
     * @external
     */
    readonly accessPolicyIdentity: CfnAccessPolicy.AccessPolicyIdentityProperty | cdk.IResolvable;
    /**
     * `AWS::IoTSiteWise::AccessPolicy.AccessPolicyPermission`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-accesspolicy.html#cfn-iotsitewise-accesspolicy-accesspolicypermission
     * @external
     */
    readonly accessPolicyPermission: string;
    /**
     * `AWS::IoTSiteWise::AccessPolicy.AccessPolicyResource`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-accesspolicy.html#cfn-iotsitewise-accesspolicy-accesspolicyresource
     * @external
     */
    readonly accessPolicyResource: CfnAccessPolicy.AccessPolicyResourceProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::IoTSiteWise::AccessPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-accesspolicy.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::AccessPolicy
 */
export declare class CfnAccessPolicy extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTSiteWise::AccessPolicy";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAccessPolicy;
    /**
     * @external
     * @cloudformationAttribute AccessPolicyArn
     */
    readonly attrAccessPolicyArn: string;
    /**
     * @external
     * @cloudformationAttribute AccessPolicyId
     */
    readonly attrAccessPolicyId: string;
    /**
     * `AWS::IoTSiteWise::AccessPolicy.AccessPolicyIdentity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-accesspolicy.html#cfn-iotsitewise-accesspolicy-accesspolicyidentity
     * @external
     */
    accessPolicyIdentity: CfnAccessPolicy.AccessPolicyIdentityProperty | cdk.IResolvable;
    /**
     * `AWS::IoTSiteWise::AccessPolicy.AccessPolicyPermission`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-accesspolicy.html#cfn-iotsitewise-accesspolicy-accesspolicypermission
     * @external
     */
    accessPolicyPermission: string;
    /**
     * `AWS::IoTSiteWise::AccessPolicy.AccessPolicyResource`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-accesspolicy.html#cfn-iotsitewise-accesspolicy-accesspolicyresource
     * @external
     */
    accessPolicyResource: CfnAccessPolicy.AccessPolicyResourceProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::IoTSiteWise::AccessPolicy`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAccessPolicyProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::IoTSiteWise::AccessPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-accesspolicy.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::AccessPolicy
 */
export declare namespace CfnAccessPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-accesspolicy-accesspolicyidentity.html
     * @external
     */
    interface AccessPolicyIdentityProperty {
        /**
         * `CfnAccessPolicy.AccessPolicyIdentityProperty.User`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-accesspolicy-accesspolicyidentity.html#cfn-iotsitewise-accesspolicy-accesspolicyidentity-user
         * @external
         */
        readonly user?: CfnAccessPolicy.UserProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTSiteWise::AccessPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-accesspolicy.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::AccessPolicy
 */
export declare namespace CfnAccessPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-accesspolicy-accesspolicyresource.html
     * @external
     */
    interface AccessPolicyResourceProperty {
        /**
         * `CfnAccessPolicy.AccessPolicyResourceProperty.Portal`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-accesspolicy-accesspolicyresource.html#cfn-iotsitewise-accesspolicy-accesspolicyresource-portal
         * @external
         */
        readonly portal?: CfnAccessPolicy.PortalProperty | cdk.IResolvable;
        /**
         * `CfnAccessPolicy.AccessPolicyResourceProperty.Project`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-accesspolicy-accesspolicyresource.html#cfn-iotsitewise-accesspolicy-accesspolicyresource-project
         * @external
         */
        readonly project?: CfnAccessPolicy.ProjectProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTSiteWise::AccessPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-accesspolicy.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::AccessPolicy
 */
export declare namespace CfnAccessPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-accesspolicy-portal.html
     * @external
     */
    interface PortalProperty {
        /**
         * `CfnAccessPolicy.PortalProperty.id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-accesspolicy-portal.html#cfn-iotsitewise-accesspolicy-portal-id
         * @external
         */
        readonly id?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTSiteWise::AccessPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-accesspolicy.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::AccessPolicy
 */
export declare namespace CfnAccessPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-accesspolicy-project.html
     * @external
     */
    interface ProjectProperty {
        /**
         * `CfnAccessPolicy.ProjectProperty.id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-accesspolicy-project.html#cfn-iotsitewise-accesspolicy-project-id
         * @external
         */
        readonly id?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTSiteWise::AccessPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-accesspolicy.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::AccessPolicy
 */
export declare namespace CfnAccessPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-accesspolicy-user.html
     * @external
     */
    interface UserProperty {
        /**
         * `CfnAccessPolicy.UserProperty.id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-accesspolicy-user.html#cfn-iotsitewise-accesspolicy-user-id
         * @external
         */
        readonly id?: string;
    }
}
/**
 * Properties for defining a `AWS::IoTSiteWise::Asset`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html
 * @external
 */
export interface CfnAssetProps {
    /**
     * `AWS::IoTSiteWise::Asset.AssetModelId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-assetmodelid
     * @external
     */
    readonly assetModelId: string;
    /**
     * `AWS::IoTSiteWise::Asset.AssetName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-assetname
     * @external
     */
    readonly assetName: string;
    /**
     * `AWS::IoTSiteWise::Asset.AssetHierarchies`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-assethierarchies
     * @external
     */
    readonly assetHierarchies?: Array<CfnAsset.AssetHierarchyProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::IoTSiteWise::Asset.AssetProperties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-assetproperties
     * @external
     */
    readonly assetProperties?: Array<CfnAsset.AssetPropertyProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::IoTSiteWise::Asset.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTSiteWise::Asset`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::Asset
 */
export declare class CfnAsset extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTSiteWise::Asset";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAsset;
    /**
     * @external
     * @cloudformationAttribute AssetArn
     */
    readonly attrAssetArn: string;
    /**
     * @external
     * @cloudformationAttribute AssetId
     */
    readonly attrAssetId: string;
    /**
     * `AWS::IoTSiteWise::Asset.AssetModelId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-assetmodelid
     * @external
     */
    assetModelId: string;
    /**
     * `AWS::IoTSiteWise::Asset.AssetName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-assetname
     * @external
     */
    assetName: string;
    /**
     * `AWS::IoTSiteWise::Asset.AssetHierarchies`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-assethierarchies
     * @external
     */
    assetHierarchies: Array<CfnAsset.AssetHierarchyProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTSiteWise::Asset.AssetProperties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-assetproperties
     * @external
     */
    assetProperties: Array<CfnAsset.AssetPropertyProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTSiteWise::Asset.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html#cfn-iotsitewise-asset-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTSiteWise::Asset`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAssetProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::IoTSiteWise::Asset`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::Asset
 */
export declare namespace CfnAsset {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assethierarchy.html
     * @external
     */
    interface AssetHierarchyProperty {
        /**
         * `CfnAsset.AssetHierarchyProperty.ChildAssetId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assethierarchy.html#cfn-iotsitewise-asset-assethierarchy-childassetid
         * @external
         */
        readonly childAssetId: string;
        /**
         * `CfnAsset.AssetHierarchyProperty.LogicalId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assethierarchy.html#cfn-iotsitewise-asset-assethierarchy-logicalid
         * @external
         */
        readonly logicalId: string;
    }
}
/**
 * A CloudFormation `AWS::IoTSiteWise::Asset`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-asset.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::Asset
 */
export declare namespace CfnAsset {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assetproperty.html
     * @external
     */
    interface AssetPropertyProperty {
        /**
         * `CfnAsset.AssetPropertyProperty.Alias`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assetproperty.html#cfn-iotsitewise-asset-assetproperty-alias
         * @external
         */
        readonly alias?: string;
        /**
         * `CfnAsset.AssetPropertyProperty.LogicalId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assetproperty.html#cfn-iotsitewise-asset-assetproperty-logicalid
         * @external
         */
        readonly logicalId: string;
        /**
         * `CfnAsset.AssetPropertyProperty.NotificationState`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-asset-assetproperty.html#cfn-iotsitewise-asset-assetproperty-notificationstate
         * @external
         */
        readonly notificationState?: string;
    }
}
/**
 * Properties for defining a `AWS::IoTSiteWise::AssetModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html
 * @external
 */
export interface CfnAssetModelProps {
    /**
     * `AWS::IoTSiteWise::AssetModel.AssetModelName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelname
     * @external
     */
    readonly assetModelName: string;
    /**
     * `AWS::IoTSiteWise::AssetModel.AssetModelDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodeldescription
     * @external
     */
    readonly assetModelDescription?: string;
    /**
     * `AWS::IoTSiteWise::AssetModel.AssetModelHierarchies`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelhierarchies
     * @external
     */
    readonly assetModelHierarchies?: Array<CfnAssetModel.AssetModelHierarchyProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::IoTSiteWise::AssetModel.AssetModelProperties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelproperties
     * @external
     */
    readonly assetModelProperties?: Array<CfnAssetModel.AssetModelPropertyProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::IoTSiteWise::AssetModel.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTSiteWise::AssetModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::AssetModel
 */
export declare class CfnAssetModel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTSiteWise::AssetModel";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAssetModel;
    /**
     * @external
     * @cloudformationAttribute AssetModelArn
     */
    readonly attrAssetModelArn: string;
    /**
     * @external
     * @cloudformationAttribute AssetModelId
     */
    readonly attrAssetModelId: string;
    /**
     * `AWS::IoTSiteWise::AssetModel.AssetModelName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelname
     * @external
     */
    assetModelName: string;
    /**
     * `AWS::IoTSiteWise::AssetModel.AssetModelDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodeldescription
     * @external
     */
    assetModelDescription: string | undefined;
    /**
     * `AWS::IoTSiteWise::AssetModel.AssetModelHierarchies`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelhierarchies
     * @external
     */
    assetModelHierarchies: Array<CfnAssetModel.AssetModelHierarchyProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTSiteWise::AssetModel.AssetModelProperties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelproperties
     * @external
     */
    assetModelProperties: Array<CfnAssetModel.AssetModelPropertyProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTSiteWise::AssetModel.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTSiteWise::AssetModel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAssetModelProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::IoTSiteWise::AssetModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::AssetModel
 */
export declare namespace CfnAssetModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelhierarchy.html
     * @external
     */
    interface AssetModelHierarchyProperty {
        /**
         * `CfnAssetModel.AssetModelHierarchyProperty.ChildAssetModelId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelhierarchy.html#cfn-iotsitewise-assetmodel-assetmodelhierarchy-childassetmodelid
         * @external
         */
        readonly childAssetModelId: string;
        /**
         * `CfnAssetModel.AssetModelHierarchyProperty.LogicalId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelhierarchy.html#cfn-iotsitewise-assetmodel-assetmodelhierarchy-logicalid
         * @external
         */
        readonly logicalId: string;
        /**
         * `CfnAssetModel.AssetModelHierarchyProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelhierarchy.html#cfn-iotsitewise-assetmodel-assetmodelhierarchy-name
         * @external
         */
        readonly name: string;
    }
}
/**
 * A CloudFormation `AWS::IoTSiteWise::AssetModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::AssetModel
 */
export declare namespace CfnAssetModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelproperty.html
     * @external
     */
    interface AssetModelPropertyProperty {
        /**
         * `CfnAssetModel.AssetModelPropertyProperty.DataType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelproperty.html#cfn-iotsitewise-assetmodel-assetmodelproperty-datatype
         * @external
         */
        readonly dataType: string;
        /**
         * `CfnAssetModel.AssetModelPropertyProperty.LogicalId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelproperty.html#cfn-iotsitewise-assetmodel-assetmodelproperty-logicalid
         * @external
         */
        readonly logicalId: string;
        /**
         * `CfnAssetModel.AssetModelPropertyProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelproperty.html#cfn-iotsitewise-assetmodel-assetmodelproperty-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnAssetModel.AssetModelPropertyProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelproperty.html#cfn-iotsitewise-assetmodel-assetmodelproperty-type
         * @external
         */
        readonly type: CfnAssetModel.PropertyTypeProperty | cdk.IResolvable;
        /**
         * `CfnAssetModel.AssetModelPropertyProperty.Unit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-assetmodelproperty.html#cfn-iotsitewise-assetmodel-assetmodelproperty-unit
         * @external
         */
        readonly unit?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTSiteWise::AssetModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::AssetModel
 */
export declare namespace CfnAssetModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-attribute.html
     * @external
     */
    interface AttributeProperty {
        /**
         * `CfnAssetModel.AttributeProperty.DefaultValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-attribute.html#cfn-iotsitewise-assetmodel-attribute-defaultvalue
         * @external
         */
        readonly defaultValue?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTSiteWise::AssetModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::AssetModel
 */
export declare namespace CfnAssetModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-expressionvariable.html
     * @external
     */
    interface ExpressionVariableProperty {
        /**
         * `CfnAssetModel.ExpressionVariableProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-expressionvariable.html#cfn-iotsitewise-assetmodel-expressionvariable-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnAssetModel.ExpressionVariableProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-expressionvariable.html#cfn-iotsitewise-assetmodel-expressionvariable-value
         * @external
         */
        readonly value: CfnAssetModel.VariableValueProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTSiteWise::AssetModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::AssetModel
 */
export declare namespace CfnAssetModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-metric.html
     * @external
     */
    interface MetricProperty {
        /**
         * `CfnAssetModel.MetricProperty.Expression`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-metric.html#cfn-iotsitewise-assetmodel-metric-expression
         * @external
         */
        readonly expression: string;
        /**
         * `CfnAssetModel.MetricProperty.Variables`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-metric.html#cfn-iotsitewise-assetmodel-metric-variables
         * @external
         */
        readonly variables: Array<CfnAssetModel.ExpressionVariableProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnAssetModel.MetricProperty.Window`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-metric.html#cfn-iotsitewise-assetmodel-metric-window
         * @external
         */
        readonly window: CfnAssetModel.MetricWindowProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTSiteWise::AssetModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::AssetModel
 */
export declare namespace CfnAssetModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-metricwindow.html
     * @external
     */
    interface MetricWindowProperty {
        /**
         * `CfnAssetModel.MetricWindowProperty.Tumbling`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-metricwindow.html#cfn-iotsitewise-assetmodel-metricwindow-tumbling
         * @external
         */
        readonly tumbling?: CfnAssetModel.TumblingWindowProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTSiteWise::AssetModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::AssetModel
 */
export declare namespace CfnAssetModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-propertytype.html
     * @external
     */
    interface PropertyTypeProperty {
        /**
         * `CfnAssetModel.PropertyTypeProperty.Attribute`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-propertytype.html#cfn-iotsitewise-assetmodel-propertytype-attribute
         * @external
         */
        readonly attribute?: CfnAssetModel.AttributeProperty | cdk.IResolvable;
        /**
         * `CfnAssetModel.PropertyTypeProperty.Metric`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-propertytype.html#cfn-iotsitewise-assetmodel-propertytype-metric
         * @external
         */
        readonly metric?: CfnAssetModel.MetricProperty | cdk.IResolvable;
        /**
         * `CfnAssetModel.PropertyTypeProperty.Transform`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-propertytype.html#cfn-iotsitewise-assetmodel-propertytype-transform
         * @external
         */
        readonly transform?: CfnAssetModel.TransformProperty | cdk.IResolvable;
        /**
         * `CfnAssetModel.PropertyTypeProperty.TypeName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-propertytype.html#cfn-iotsitewise-assetmodel-propertytype-typename
         * @external
         */
        readonly typeName: string;
    }
}
/**
 * A CloudFormation `AWS::IoTSiteWise::AssetModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::AssetModel
 */
export declare namespace CfnAssetModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-transform.html
     * @external
     */
    interface TransformProperty {
        /**
         * `CfnAssetModel.TransformProperty.Expression`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-transform.html#cfn-iotsitewise-assetmodel-transform-expression
         * @external
         */
        readonly expression: string;
        /**
         * `CfnAssetModel.TransformProperty.Variables`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-transform.html#cfn-iotsitewise-assetmodel-transform-variables
         * @external
         */
        readonly variables: Array<CfnAssetModel.ExpressionVariableProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTSiteWise::AssetModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::AssetModel
 */
export declare namespace CfnAssetModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-tumblingwindow.html
     * @external
     */
    interface TumblingWindowProperty {
        /**
         * `CfnAssetModel.TumblingWindowProperty.Interval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-tumblingwindow.html#cfn-iotsitewise-assetmodel-tumblingwindow-interval
         * @external
         */
        readonly interval: string;
    }
}
/**
 * A CloudFormation `AWS::IoTSiteWise::AssetModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::AssetModel
 */
export declare namespace CfnAssetModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-variablevalue.html
     * @external
     */
    interface VariableValueProperty {
        /**
         * `CfnAssetModel.VariableValueProperty.HierarchyLogicalId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-variablevalue.html#cfn-iotsitewise-assetmodel-variablevalue-hierarchylogicalid
         * @external
         */
        readonly hierarchyLogicalId?: string;
        /**
         * `CfnAssetModel.VariableValueProperty.PropertyLogicalId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-assetmodel-variablevalue.html#cfn-iotsitewise-assetmodel-variablevalue-propertylogicalid
         * @external
         */
        readonly propertyLogicalId: string;
    }
}
/**
 * Properties for defining a `AWS::IoTSiteWise::Dashboard`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-dashboard.html
 * @external
 */
export interface CfnDashboardProps {
    /**
     * `AWS::IoTSiteWise::Dashboard.DashboardDefinition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-dashboard.html#cfn-iotsitewise-dashboard-dashboarddefinition
     * @external
     */
    readonly dashboardDefinition: string;
    /**
     * `AWS::IoTSiteWise::Dashboard.DashboardDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-dashboard.html#cfn-iotsitewise-dashboard-dashboarddescription
     * @external
     */
    readonly dashboardDescription: string;
    /**
     * `AWS::IoTSiteWise::Dashboard.DashboardName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-dashboard.html#cfn-iotsitewise-dashboard-dashboardname
     * @external
     */
    readonly dashboardName: string;
    /**
     * `AWS::IoTSiteWise::Dashboard.ProjectId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-dashboard.html#cfn-iotsitewise-dashboard-projectid
     * @external
     */
    readonly projectId?: string;
    /**
     * `AWS::IoTSiteWise::Dashboard.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-dashboard.html#cfn-iotsitewise-dashboard-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTSiteWise::Dashboard`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-dashboard.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::Dashboard
 */
export declare class CfnDashboard extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTSiteWise::Dashboard";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDashboard;
    /**
     * @external
     * @cloudformationAttribute DashboardArn
     */
    readonly attrDashboardArn: string;
    /**
     * @external
     * @cloudformationAttribute DashboardId
     */
    readonly attrDashboardId: string;
    /**
     * `AWS::IoTSiteWise::Dashboard.DashboardDefinition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-dashboard.html#cfn-iotsitewise-dashboard-dashboarddefinition
     * @external
     */
    dashboardDefinition: string;
    /**
     * `AWS::IoTSiteWise::Dashboard.DashboardDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-dashboard.html#cfn-iotsitewise-dashboard-dashboarddescription
     * @external
     */
    dashboardDescription: string;
    /**
     * `AWS::IoTSiteWise::Dashboard.DashboardName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-dashboard.html#cfn-iotsitewise-dashboard-dashboardname
     * @external
     */
    dashboardName: string;
    /**
     * `AWS::IoTSiteWise::Dashboard.ProjectId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-dashboard.html#cfn-iotsitewise-dashboard-projectid
     * @external
     */
    projectId: string | undefined;
    /**
     * `AWS::IoTSiteWise::Dashboard.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-dashboard.html#cfn-iotsitewise-dashboard-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTSiteWise::Dashboard`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDashboardProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::IoTSiteWise::Gateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-gateway.html
 * @external
 */
export interface CfnGatewayProps {
    /**
     * `AWS::IoTSiteWise::Gateway.GatewayName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-gateway.html#cfn-iotsitewise-gateway-gatewayname
     * @external
     */
    readonly gatewayName: string;
    /**
     * `AWS::IoTSiteWise::Gateway.GatewayPlatform`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-gateway.html#cfn-iotsitewise-gateway-gatewayplatform
     * @external
     */
    readonly gatewayPlatform: CfnGateway.GatewayPlatformProperty | cdk.IResolvable;
    /**
     * `AWS::IoTSiteWise::Gateway.GatewayCapabilitySummaries`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-gateway.html#cfn-iotsitewise-gateway-gatewaycapabilitysummaries
     * @external
     */
    readonly gatewayCapabilitySummaries?: Array<CfnGateway.GatewayCapabilitySummaryProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::IoTSiteWise::Gateway.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-gateway.html#cfn-iotsitewise-gateway-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTSiteWise::Gateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-gateway.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::Gateway
 */
export declare class CfnGateway extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTSiteWise::Gateway";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnGateway;
    /**
     * @external
     * @cloudformationAttribute GatewayId
     */
    readonly attrGatewayId: string;
    /**
     * `AWS::IoTSiteWise::Gateway.GatewayName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-gateway.html#cfn-iotsitewise-gateway-gatewayname
     * @external
     */
    gatewayName: string;
    /**
     * `AWS::IoTSiteWise::Gateway.GatewayPlatform`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-gateway.html#cfn-iotsitewise-gateway-gatewayplatform
     * @external
     */
    gatewayPlatform: CfnGateway.GatewayPlatformProperty | cdk.IResolvable;
    /**
     * `AWS::IoTSiteWise::Gateway.GatewayCapabilitySummaries`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-gateway.html#cfn-iotsitewise-gateway-gatewaycapabilitysummaries
     * @external
     */
    gatewayCapabilitySummaries: Array<CfnGateway.GatewayCapabilitySummaryProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTSiteWise::Gateway.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-gateway.html#cfn-iotsitewise-gateway-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTSiteWise::Gateway`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnGatewayProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::IoTSiteWise::Gateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-gateway.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::Gateway
 */
export declare namespace CfnGateway {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-gateway-gatewaycapabilitysummary.html
     * @external
     */
    interface GatewayCapabilitySummaryProperty {
        /**
         * `CfnGateway.GatewayCapabilitySummaryProperty.CapabilityConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-gateway-gatewaycapabilitysummary.html#cfn-iotsitewise-gateway-gatewaycapabilitysummary-capabilityconfiguration
         * @external
         */
        readonly capabilityConfiguration?: string;
        /**
         * `CfnGateway.GatewayCapabilitySummaryProperty.CapabilityNamespace`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-gateway-gatewaycapabilitysummary.html#cfn-iotsitewise-gateway-gatewaycapabilitysummary-capabilitynamespace
         * @external
         */
        readonly capabilityNamespace: string;
    }
}
/**
 * A CloudFormation `AWS::IoTSiteWise::Gateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-gateway.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::Gateway
 */
export declare namespace CfnGateway {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-gateway-gatewayplatform.html
     * @external
     */
    interface GatewayPlatformProperty {
        /**
         * `CfnGateway.GatewayPlatformProperty.Greengrass`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-gateway-gatewayplatform.html#cfn-iotsitewise-gateway-gatewayplatform-greengrass
         * @external
         */
        readonly greengrass: CfnGateway.GreengrassProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTSiteWise::Gateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-gateway.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::Gateway
 */
export declare namespace CfnGateway {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-gateway-greengrass.html
     * @external
     */
    interface GreengrassProperty {
        /**
         * `CfnGateway.GreengrassProperty.GroupArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-gateway-greengrass.html#cfn-iotsitewise-gateway-greengrass-grouparn
         * @external
         */
        readonly groupArn: string;
    }
}
/**
 * Properties for defining a `AWS::IoTSiteWise::Portal`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html
 * @external
 */
export interface CfnPortalProps {
    /**
     * `AWS::IoTSiteWise::Portal.PortalContactEmail`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-portalcontactemail
     * @external
     */
    readonly portalContactEmail: string;
    /**
     * `AWS::IoTSiteWise::Portal.PortalName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-portalname
     * @external
     */
    readonly portalName: string;
    /**
     * `AWS::IoTSiteWise::Portal.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-rolearn
     * @external
     */
    readonly roleArn: string;
    /**
     * `AWS::IoTSiteWise::Portal.PortalDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-portaldescription
     * @external
     */
    readonly portalDescription?: string;
    /**
     * `AWS::IoTSiteWise::Portal.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTSiteWise::Portal`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::Portal
 */
export declare class CfnPortal extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTSiteWise::Portal";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPortal;
    /**
     * @external
     * @cloudformationAttribute PortalArn
     */
    readonly attrPortalArn: string;
    /**
     * @external
     * @cloudformationAttribute PortalClientId
     */
    readonly attrPortalClientId: string;
    /**
     * @external
     * @cloudformationAttribute PortalId
     */
    readonly attrPortalId: string;
    /**
     * @external
     * @cloudformationAttribute PortalStartUrl
     */
    readonly attrPortalStartUrl: string;
    /**
     * `AWS::IoTSiteWise::Portal.PortalContactEmail`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-portalcontactemail
     * @external
     */
    portalContactEmail: string;
    /**
     * `AWS::IoTSiteWise::Portal.PortalName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-portalname
     * @external
     */
    portalName: string;
    /**
     * `AWS::IoTSiteWise::Portal.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-rolearn
     * @external
     */
    roleArn: string;
    /**
     * `AWS::IoTSiteWise::Portal.PortalDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-portaldescription
     * @external
     */
    portalDescription: string | undefined;
    /**
     * `AWS::IoTSiteWise::Portal.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTSiteWise::Portal`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPortalProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::IoTSiteWise::Portal`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::Portal
 */
export declare namespace CfnPortal {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-portal-monitorerrordetails.html
     * @external
     */
    interface MonitorErrorDetailsProperty {
        /**
         * `CfnPortal.MonitorErrorDetailsProperty.code`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-portal-monitorerrordetails.html#cfn-iotsitewise-portal-monitorerrordetails-code
         * @external
         */
        readonly code?: string;
        /**
         * `CfnPortal.MonitorErrorDetailsProperty.message`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-portal-monitorerrordetails.html#cfn-iotsitewise-portal-monitorerrordetails-message
         * @external
         */
        readonly message?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTSiteWise::Portal`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::Portal
 */
export declare namespace CfnPortal {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-portal-portalstatus.html
     * @external
     */
    interface PortalStatusProperty {
        /**
         * `CfnPortal.PortalStatusProperty.error`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-portal-portalstatus.html#cfn-iotsitewise-portal-portalstatus-error
         * @external
         */
        readonly error?: CfnPortal.MonitorErrorDetailsProperty | cdk.IResolvable;
        /**
         * `CfnPortal.PortalStatusProperty.state`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotsitewise-portal-portalstatus.html#cfn-iotsitewise-portal-portalstatus-state
         * @external
         */
        readonly state: string;
    }
}
/**
 * Properties for defining a `AWS::IoTSiteWise::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-project.html
 * @external
 */
export interface CfnProjectProps {
    /**
     * `AWS::IoTSiteWise::Project.PortalId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-project.html#cfn-iotsitewise-project-portalid
     * @external
     */
    readonly portalId: string;
    /**
     * `AWS::IoTSiteWise::Project.ProjectName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-project.html#cfn-iotsitewise-project-projectname
     * @external
     */
    readonly projectName: string;
    /**
     * `AWS::IoTSiteWise::Project.ProjectDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-project.html#cfn-iotsitewise-project-projectdescription
     * @external
     */
    readonly projectDescription?: string;
    /**
     * `AWS::IoTSiteWise::Project.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-project.html#cfn-iotsitewise-project-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTSiteWise::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-project.html
 * @external
 * @cloudformationResource AWS::IoTSiteWise::Project
 */
export declare class CfnProject extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTSiteWise::Project";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnProject;
    /**
     * @external
     * @cloudformationAttribute ProjectArn
     */
    readonly attrProjectArn: string;
    /**
     * @external
     * @cloudformationAttribute ProjectId
     */
    readonly attrProjectId: string;
    /**
     * `AWS::IoTSiteWise::Project.PortalId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-project.html#cfn-iotsitewise-project-portalid
     * @external
     */
    portalId: string;
    /**
     * `AWS::IoTSiteWise::Project.ProjectName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-project.html#cfn-iotsitewise-project-projectname
     * @external
     */
    projectName: string;
    /**
     * `AWS::IoTSiteWise::Project.ProjectDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-project.html#cfn-iotsitewise-project-projectdescription
     * @external
     */
    projectDescription: string | undefined;
    /**
     * `AWS::IoTSiteWise::Project.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-project.html#cfn-iotsitewise-project-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTSiteWise::Project`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnProjectProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
