"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
/**
 * Use a Lamda Function as the destination for a log subscription.
 *
 * @stability stable
 */
class LambdaDestination {
    /**
     * @stability stable
     */
    constructor(fn) {
        this.fn = fn;
    }
    /**
     * Return the properties required to send subscription events to this destination.
     *
     * If necessary, the destination can use the properties of the SubscriptionFilter
     * object itself to configure its permissions to allow the subscription to write
     * to it.
     *
     * The destination may reconfigure its own permissions in response to this
     * function call.
     *
     * @stability stable
     */
    bind(scope, logGroup) {
        const arn = logGroup.logGroupArn;
        this.fn.addPermission('CanInvokeLambda', {
            principal: new iam.ServicePrincipal('logs.amazonaws.com'),
            sourceArn: arn,
            // Using SubScription Filter as scope is okay, since every Subscription Filter has only
            // one destination.
            scope,
        });
        return { arn: this.fn.functionArn };
    }
}
exports.LambdaDestination = LambdaDestination;
_a = JSII_RTTI_SYMBOL_1;
LambdaDestination[_a] = { fqn: "@aws-cdk/aws-logs-destinations.LambdaDestination", version: "1.100.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGFtYmRhLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibGFtYmRhLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsd0NBQXdDOzs7Ozs7QUFReEMsTUFBYSxpQkFBaUI7Ozs7SUFDNUIsWUFBNkIsRUFBb0I7UUFBcEIsT0FBRSxHQUFGLEVBQUUsQ0FBa0I7SUFDakQsQ0FBQzs7Ozs7Ozs7Ozs7OztJQUVNLElBQUksQ0FBQyxLQUFnQixFQUFFLFFBQXdCO1FBQ3BELE1BQU0sR0FBRyxHQUFHLFFBQVEsQ0FBQyxXQUFXLENBQUM7UUFFakMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxhQUFhLENBQUMsaUJBQWlCLEVBQUU7WUFDdkMsU0FBUyxFQUFFLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9CQUFvQixDQUFDO1lBQ3pELFNBQVMsRUFBRSxHQUFHO1lBQ2QsdUZBQXVGO1lBQ3ZGLG1CQUFtQjtZQUNuQixLQUFLO1NBQ04sQ0FBQyxDQUFDO1FBQ0gsT0FBTyxFQUFFLEdBQUcsRUFBRSxJQUFJLENBQUMsRUFBRSxDQUFDLFdBQVcsRUFBRSxDQUFDO0lBQ3RDLENBQUM7O0FBZkgsOENBZ0JDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgaWFtIGZyb20gJ0Bhd3MtY2RrL2F3cy1pYW0nO1xuaW1wb3J0ICogYXMgbGFtYmRhIGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0ICogYXMgbG9ncyBmcm9tICdAYXdzLWNkay9hd3MtbG9ncyc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIExhbWJkYURlc3RpbmF0aW9uIGltcGxlbWVudHMgbG9ncy5JTG9nU3Vic2NyaXB0aW9uRGVzdGluYXRpb24ge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IGZuOiBsYW1iZGEuSUZ1bmN0aW9uKSB7XG4gIH1cblxuICBwdWJsaWMgYmluZChzY29wZTogQ29uc3RydWN0LCBsb2dHcm91cDogbG9ncy5JTG9nR3JvdXApOiBsb2dzLkxvZ1N1YnNjcmlwdGlvbkRlc3RpbmF0aW9uQ29uZmlnIHtcbiAgICBjb25zdCBhcm4gPSBsb2dHcm91cC5sb2dHcm91cEFybjtcblxuICAgIHRoaXMuZm4uYWRkUGVybWlzc2lvbignQ2FuSW52b2tlTGFtYmRhJywge1xuICAgICAgcHJpbmNpcGFsOiBuZXcgaWFtLlNlcnZpY2VQcmluY2lwYWwoJ2xvZ3MuYW1hem9uYXdzLmNvbScpLFxuICAgICAgc291cmNlQXJuOiBhcm4sXG4gICAgICAvLyBVc2luZyBTdWJTY3JpcHRpb24gRmlsdGVyIGFzIHNjb3BlIGlzIG9rYXksIHNpbmNlIGV2ZXJ5IFN1YnNjcmlwdGlvbiBGaWx0ZXIgaGFzIG9ubHlcbiAgICAgIC8vIG9uZSBkZXN0aW5hdGlvbi5cbiAgICAgIHNjb3BlLFxuICAgIH0pO1xuICAgIHJldHVybiB7IGFybjogdGhpcy5mbi5mdW5jdGlvbkFybiB9O1xuICB9XG59XG4iXX0=