import { IEventBus } from 'aws-cdk-lib/aws-events';
import { Function } from 'aws-cdk-lib/aws-lambda';
import { ISecret } from 'aws-cdk-lib/aws-secretsmanager';
import { Construct } from 'constructs';
import { Partner } from './Partner';
import { InvocationAlarm } from './Util';
export interface PartnerFunctionProps {
    /**
       * SM Secret containing the secret string used to validate webhook events.
       */
    readonly webhookSecret: ISecret;
    /**
       * Eventbus to send Partner events to.
       */
    readonly eventBus: IEventBus;
    /**
       * Maximum number of concurrent invocations on the fURL function before triggering the alarm.
       */
    readonly lambdaInvocationAlarmThreshold: number;
    /**
       * The partner to create an events processor for.
       */
    readonly eventbridgePartner: Partner;
}
/**
 * Abstract class for Lambda-driven Eventbridge integrations.
 * This only works because the pattern for the S3 Keys lines up to: lambda-templates/<partner>-lambdasrc.zip
 * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-saas-furls.html
 */
export declare abstract class PartnerProcessor extends Construct {
    partnerEventsFunction: Function;
    invocationAlarm: InvocationAlarm;
    constructor(scope: Construct, id: string, props: PartnerFunctionProps);
}
