"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationAssociator = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const application_1 = require("./application");
const stack_associator_1 = require("./aspects/stack-associator");
/**
 * An AppRegistry construct to automatically create an application with the given name and description.
 *
 * The application name must be unique at the account level and it's immutable.
 * This construct will automatically associate all stacks in the given scope, however
 * in case of a `Pipeline` stack, stage underneath the pipeline will not automatically be associated and
 * needs to be associated separately.
 *
 * If cross account stack is detected, then this construct will automatically share the application to consumer accounts.
 * Cross account feature will only work for non environment agnostic stacks.
 */
class ApplicationAssociator extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.associatedStages = new Set();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_servicecatalogappregistry_alpha_ApplicationAssociatorProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ApplicationAssociator);
            }
            throw error;
        }
        const applicationStack = new cdk.Stack(scope, 'ApplicationAssociatorStack', props.stackProps);
        if (!!props.applicationArnValue) {
            this.application = application_1.Application.fromApplicationArn(applicationStack, 'ImportedApplication', props.applicationArnValue);
        }
        else if (!!props.applicationName) {
            this.application = new application_1.Application(applicationStack, 'DefaultCdkApplication', {
                applicationName: props.applicationName,
                description: props.description,
            });
        }
        else {
            throw new Error('Please provide either ARN or application name.');
        }
        cdk.Aspects.of(scope).add(new stack_associator_1.CheckedStageStackAssociator(this));
    }
    /**
     * Associate this application with the given stage.
     *
     */
    associateStage(stage) {
        this.associatedStages.add(stage);
        cdk.Aspects.of(stage).add(new stack_associator_1.CheckedStageStackAssociator(this));
        return stage;
    }
    /**
     * Validates if a stage is already associated to the application.
     *
     */
    isStageAssociated(stage) {
        return this.associatedStages.has(stage);
    }
    /**
     * Get the AppRegistry application.
     *
     */
    get appRegistryApplication() {
        return this.application;
    }
}
exports.ApplicationAssociator = ApplicationAssociator;
_a = JSII_RTTI_SYMBOL_1;
ApplicationAssociator[_a] = { fqn: "@aws-cdk/aws-servicecatalogappregistry-alpha.ApplicationAssociator", version: "2.45.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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