"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sns = require("@aws-cdk/aws-sns");
/**
 * Use an email address as a subscription target
 *
 * Email subscriptions require confirmation.
 */
class EmailSubscription {
    constructor(emailAddress, props = {}) {
        this.emailAddress = emailAddress;
        this.props = props;
    }
    bind(_topic) {
        return {
            subscriberId: this.emailAddress,
            endpoint: this.emailAddress,
            protocol: this.props.json ? sns.SubscriptionProtocol.EMAIL_JSON : sns.SubscriptionProtocol.EMAIL,
            filterPolicy: this.props.filterPolicy,
        };
    }
}
exports.EmailSubscription = EmailSubscription;
//# sourceMappingURL=data:application/json;base64,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