# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/leaderboard.ipynb (unless otherwise specified).

__all__ = ['get_leaderboard_distribution']

# Cell
import pandas as pd
import os
import plotly.graph_objects as go
import plotly.express as px
import typing
from fastcore.all import *
from ashrae import loading

# Cell
@typed
def get_leaderboard_distribution(df:pd.DataFrame):
    return (df.sort_values('Score')
              .groupby('Score')
              .size()
              .to_frame('Count')
              .reset_index()
              .assign(**{'Cumulative share (%)': lambda x: 100 * x['Count'].cumsum()/x['Count'].sum()}))