"use strict";
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Route53ResolverMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class Route53ResolverMetrics {
    static inboundQueryVolumeSum(dimensions) {
        return {
            namespace: 'AWS/Route53Resolver',
            metricName: 'InboundQueryVolume',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static outboundQueryVolumeSum(dimensions) {
        return {
            namespace: 'AWS/Route53Resolver',
            metricName: 'OutboundQueryVolume',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static outboundQueryAggregateVolumeSum(dimensions) {
        return {
            namespace: 'AWS/Route53Resolver',
            metricName: 'OutboundQueryAggregateVolume',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
}
exports.Route53ResolverMetrics = Route53ResolverMetrics;
//# sourceMappingURL=data:application/json;base64,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