# -*- coding: utf-8 -*-
from setuptools import setup
import addressformat



setup(name='addressformat',
      version=addressformat.__version__,
      description='地址省市区解析',
      long_description="地址解析模块",
      license="MIT",
      classifiers=[
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Natural Language :: Chinese (Simplified)',
        'Programming Language :: Python :: 3.6',
        'Topic :: Text Processing',
        'Topic :: Text Processing :: Indexing',
      ],
      packages=['addressformat', 'addressformat.resources','addressformat.entitywords'],

      package_dir={'addressformat': 'addressformat', 'addressformat.resources': 'addressformat/resources','addressformat.entitywords':"addressformat/entitywords"},
      package_data={'': ['*']},
      include_package_data=True,
      )
