import { BundlingDockerImage } from '@aws-cdk/core';
/**
 * (experimental) Bundling options.
 *
 * @experimental
 */
export interface BundlingOptions {
    /**
     * (experimental) Whether to minify files when bundling.
     *
     * @default false
     * @experimental
     */
    readonly minify?: boolean;
    /**
     * (experimental) Whether to include source maps when bundling.
     *
     * @default false
     * @experimental
     */
    readonly sourceMap?: boolean;
    /**
     * (experimental) Target environment for the generated JavaScript code.
     *
     * @default - the node version of the runtime
     * @see https://esbuild.github.io/api/#target
     * @experimental
     */
    readonly target?: string;
    /**
     * (experimental) Use loaders to change how a given input file is interpreted.
     *
     * Configuring a loader for a given file type lets you load that file type with
     * an `import` statement or a `require` call.
     *
     * @default - use esbuild default loaders
     * @see https://esbuild.github.io/api/#loader
     * @experimental
     * @example
     *
     * { '.png': 'dataurl' }
     */
    readonly loader?: {
        [ext: string]: string;
    };
    /**
     * (experimental) Environment variables defined when bundling runs.
     *
     * @default - no environment variables are defined.
     * @experimental
     */
    readonly bundlingEnvironment?: {
        [key: string]: string;
    };
    /**
     * (experimental) A list of modules that should be considered as externals (already available in the runtime).
     *
     * @default ['aws-sdk']
     * @experimental
     */
    readonly externalModules?: string[];
    /**
     * (experimental) A list of modules that should be installed instead of bundled.
     *
     * Modules are
     * installed in a Lambda compatible environnment only when bundling runs in
     * Docker.
     *
     * @default - all modules are bundled
     * @experimental
     */
    readonly nodeModules?: string[];
    /**
     * (experimental) The version of esbuild to use when running in a Docker container.
     *
     * @default - latest v0
     * @experimental
     */
    readonly esbuildVersion?: string;
    /**
     * (experimental) Build arguments to pass when building the bundling image.
     *
     * @default - no build arguments are passed
     * @experimental
     */
    readonly buildArgs?: {
        [key: string]: string;
    };
    /**
     * (experimental) Force bundling in a Docker container even if local bundling is possible.
     *
     * This is useful if your function relies on node modules
     * that should be installed (`nodeModules`) in a Lambda compatible
     * environment.
     *
     * @default false
     * @experimental
     */
    readonly forceDockerBundling?: boolean;
    /**
     * (experimental) A custom bundling Docker image.
     *
     * This image should have esbuild installed globally. If you plan to use `nodeModules`
     * it should also have `npm` or `yarn` depending on the lock file you're using.
     *
     * See https://github.com/aws/aws-cdk/blob/master/packages/%40aws-cdk/aws-lambda-nodejs/lib/Dockerfile
     * for the default image provided by @aws-cdk/aws-lambda-nodejs.
     *
     * @default - use the Docker image provided by
     * @experimental
     * @aws-cdk /aws-lambda-nodejs
     */
    readonly bundlingDockerImage?: BundlingDockerImage;
}
