# coding: utf-8

"""
    ARLAS CITY API

    ARLAS-city content manager

    OpenAPI spec version: 0.1.0
    Contact: contact@gisaia.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ProcessApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def get_jobs(self, collection, **kwargs):
        """
        List of processing jobs.
        List of processing jobs.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_jobs(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: Destination collection for the upload (required)
        :param int size: Page Size
        :param int page: Page JOB_ID
        :param str before: Before date criterion in ISO-8601 extended local date format
        :param str after: After criterion in ISO-8601 extended local date format
        :param bool pretty: Pretty print
        :return: list[Job]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_jobs_with_http_info(collection, **kwargs)
        else:
            (data) = self.get_jobs_with_http_info(collection, **kwargs)
            return data

    def get_jobs_with_http_info(self, collection, **kwargs):
        """
        List of processing jobs.
        List of processing jobs.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_jobs_with_http_info(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: Destination collection for the upload (required)
        :param int size: Page Size
        :param int page: Page JOB_ID
        :param str before: Before date criterion in ISO-8601 extended local date format
        :param str after: After criterion in ISO-8601 extended local date format
        :param bool pretty: Pretty print
        :return: list[Job]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'size', 'page', 'before', 'after', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_jobs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params) or (params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `get_jobs`")

        if 'size' in params and params['size'] < 1:
            raise ValueError("Invalid value for parameter `size` when calling `get_jobs`, must be a value greater than or equal to `1`")
        if 'page' in params and params['page'] < 1:
            raise ValueError("Invalid value for parameter `page` when calling `get_jobs`, must be a value greater than or equal to `1`")

        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']

        query_params = []
        if 'size' in params:
            query_params.append(('size', params['size']))
        if 'page' in params:
            query_params.append(('page', params['page']))
        if 'before' in params:
            query_params.append(('before', params['before']))
        if 'after' in params:
            query_params.append(('after', params['after']))
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/process/{collection}/jobs', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[Job]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def job_status(self, collection, id, **kwargs):
        """
        Status of a job.
        Status of a job.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.job_status(collection, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: Destination collection for the upload (required)
        :param str id: Job's id (required)
        :param bool pretty: Pretty print
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.job_status_with_http_info(collection, id, **kwargs)
        else:
            (data) = self.job_status_with_http_info(collection, id, **kwargs)
            return data

    def job_status_with_http_info(self, collection, id, **kwargs):
        """
        Status of a job.
        Status of a job.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.job_status_with_http_info(collection, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: Destination collection for the upload (required)
        :param str id: Job's id (required)
        :param bool pretty: Pretty print
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'id', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method job_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params) or (params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `job_status`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `job_status`")


        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/process/{collection}/jobs/{id}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Job',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def post_job(self, collection, job_order, **kwargs):
        """
        Trigger a processing job
        Trigger a processing job
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_job(collection, job_order, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: Destination collection for the upload (required)
        :param JobOrder job_order: Job order (required)
        :param bool pretty: Pretty print
        :return: CollectionReference
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.post_job_with_http_info(collection, job_order, **kwargs)
        else:
            (data) = self.post_job_with_http_info(collection, job_order, **kwargs)
            return data

    def post_job_with_http_info(self, collection, job_order, **kwargs):
        """
        Trigger a processing job
        Trigger a processing job
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_job_with_http_info(collection, job_order, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: Destination collection for the upload (required)
        :param JobOrder job_order: Job order (required)
        :param bool pretty: Pretty print
        :return: CollectionReference
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'job_order', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params) or (params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `post_job`")
        # verify the required parameter 'job_order' is set
        if ('job_order' not in params) or (params['job_order'] is None):
            raise ValueError("Missing the required parameter `job_order` when calling `post_job`")


        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'job_order' in params:
            body_params = params['job_order']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/process/{collection}/jobs', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CollectionReference',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
