# coding: utf-8

"""
    ARLAS CITY API

    ARLAS-city content manager

    OpenAPI spec version: 0.1.0
    Contact: contact@gisaia.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class DataApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_archive(self, collection, id, **kwargs):
        """
        Delete GTFS archive.
        Delete GTFS zip archive
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_archive(collection, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: Destination collection for the upload (required)
        :param str id: Archive's id (required)
        :return: Archive
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_archive_with_http_info(collection, id, **kwargs)
        else:
            (data) = self.delete_archive_with_http_info(collection, id, **kwargs)
            return data

    def delete_archive_with_http_info(self, collection, id, **kwargs):
        """
        Delete GTFS archive.
        Delete GTFS zip archive
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_archive_with_http_info(collection, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: Destination collection for the upload (required)
        :param str id: Archive's id (required)
        :return: Archive
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_archive" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params) or (params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `delete_archive`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_archive`")


        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/data/{collection}/archives/{id}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Archive',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_archive(self, collection, id, **kwargs):
        """
        Delete GTFS archive.
        Delete GTFS zip archive
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_archive(collection, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: Destination collection for the upload (required)
        :param str id: Archive's id (required)
        :return: Archive
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_archive_with_http_info(collection, id, **kwargs)
        else:
            (data) = self.get_archive_with_http_info(collection, id, **kwargs)
            return data

    def get_archive_with_http_info(self, collection, id, **kwargs):
        """
        Delete GTFS archive.
        Delete GTFS zip archive
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_archive_with_http_info(collection, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: Destination collection for the upload (required)
        :param str id: Archive's id (required)
        :return: Archive
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_archive" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params) or (params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `get_archive`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_archive`")


        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/data/{collection}/archives/{id}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Archive',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_archives(self, collection, **kwargs):
        """
        List of GTFS archives.
        List of GTFS archives
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_archives(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: Destination collection for the upload (required)
        :param int size: Page Size
        :param int page: Page JOB_ID
        :param str before: Before date criterion in ISO-8601 extended local date format
        :param str after: After criterion in ISO-8601 extended local date format
        :param str type: GTFS archive type (all types if not specified)
        :param bool extended: Returns extended version of requested objects
        :param bool pretty: Pretty print
        :return: Archive
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_archives_with_http_info(collection, **kwargs)
        else:
            (data) = self.get_archives_with_http_info(collection, **kwargs)
            return data

    def get_archives_with_http_info(self, collection, **kwargs):
        """
        List of GTFS archives.
        List of GTFS archives
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_archives_with_http_info(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: Destination collection for the upload (required)
        :param int size: Page Size
        :param int page: Page JOB_ID
        :param str before: Before date criterion in ISO-8601 extended local date format
        :param str after: After criterion in ISO-8601 extended local date format
        :param str type: GTFS archive type (all types if not specified)
        :param bool extended: Returns extended version of requested objects
        :param bool pretty: Pretty print
        :return: Archive
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'size', 'page', 'before', 'after', 'type', 'extended', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_archives" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params) or (params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `get_archives`")

        if 'size' in params and params['size'] < 1:
            raise ValueError("Invalid value for parameter `size` when calling `get_archives`, must be a value greater than or equal to `1`")
        if 'page' in params and params['page'] < 1:
            raise ValueError("Invalid value for parameter `page` when calling `get_archives`, must be a value greater than or equal to `1`")

        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']

        query_params = []
        if 'size' in params:
            query_params.append(('size', params['size']))
        if 'page' in params:
            query_params.append(('page', params['page']))
        if 'before' in params:
            query_params.append(('before', params['before']))
        if 'after' in params:
            query_params.append(('after', params['after']))
        if 'type' in params:
            query_params.append(('type', params['type']))
        if 'extended' in params:
            query_params.append(('extended', params['extended']))
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/data/{collection}/archives', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Archive',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def post_archive(self, collection, type, **kwargs):
        """
        Upload a GTFS archive.
        Upload GTFS data as a zip archive
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_archive(collection, type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: Destination collection for the upload (required)
        :param str type: GTFS archive type (required)
        :param bool validate:
        :param int max:
        :param file file:
        :return: Archive
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.post_archive_with_http_info(collection, type, **kwargs)
        else:
            (data) = self.post_archive_with_http_info(collection, type, **kwargs)
            return data

    def post_archive_with_http_info(self, collection, type, **kwargs):
        """
        Upload a GTFS archive.
        Upload GTFS data as a zip archive
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_archive_with_http_info(collection, type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: Destination collection for the upload (required)
        :param str type: GTFS archive type (required)
        :param bool validate:
        :param int max:
        :param file file:
        :return: Archive
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'type', 'validate', 'max', 'file']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_archive" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params) or (params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `post_archive`")
        # verify the required parameter 'type' is set
        if ('type' not in params) or (params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `post_archive`")


        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'validate' in params:
            form_params.append(('validate', params['validate']))
        if 'max' in params:
            form_params.append(('max', params['max']))
        if 'file' in params:
            local_var_files['file'] = params['file']

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['multipart/form-data'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/data/{collection}/archives', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Archive',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
