# arlas-city-api-python
ARLAS-city content manager

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 0.1.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen
For more information, please visit [http://www.gisaia.com/](http://www.gisaia.com/)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import arlas_city_api_python 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import arlas_city_api_python
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import arlas_city_api_python
from arlas_city_api_python.rest import ApiException
from pprint import pprint
# create an instance of the API class
api_instance = arlas_city_api_python.DataApi()
collection = 'collection_example' # str | Destination collection for the upload
id = 'id_example' # str | Archive's id

try:
    # Delete GTFS archive.
    api_response = api_instance.delete_archive(collection, id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DataApi->delete_archive: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/arlas_city_server*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DataApi* | [**delete_archive**](docs/DataApi.md#delete_archive) | **DELETE** /data/{collection}/archives/{id} | Delete GTFS archive.
*DataApi* | [**get_archive**](docs/DataApi.md#get_archive) | **GET** /data/{collection}/archives/{id} | Delete GTFS archive.
*DataApi* | [**get_archives**](docs/DataApi.md#get_archives) | **GET** /data/{collection}/archives | List of GTFS archives.
*DataApi* | [**post_archive**](docs/DataApi.md#post_archive) | **POST** /data/{collection}/archives | Upload a GTFS archive.
*ProcessApi* | [**get_jobs**](docs/ProcessApi.md#get_jobs) | **GET** /process/{collection}/jobs | List of processing jobs.
*ProcessApi* | [**job_status**](docs/ProcessApi.md#job_status) | **GET** /process/{collection}/jobs/{id} | Status of a job.
*ProcessApi* | [**post_job**](docs/ProcessApi.md#post_job) | **POST** /process/{collection}/jobs | Trigger a processing job


## Documentation For Models

 - [Archive](docs/Archive.md)
 - [Bbox](docs/Bbox.md)
 - [CollectionReference](docs/CollectionReference.md)
 - [CollectionReferenceParameters](docs/CollectionReferenceParameters.md)
 - [DublinCoreElementName](docs/DublinCoreElementName.md)
 - [Error](docs/Error.md)
 - [Expression](docs/Expression.md)
 - [Feed](docs/Feed.md)
 - [FeedStatistics](docs/FeedStatistics.md)
 - [Filter](docs/Filter.md)
 - [Generator](docs/Generator.md)
 - [Inspire](docs/Inspire.md)
 - [InspireLimitationAccess](docs/InspireLimitationAccess.md)
 - [InspireSpatialResolution](docs/InspireSpatialResolution.md)
 - [InspireURI](docs/InspireURI.md)
 - [IssuesDetails](docs/IssuesDetails.md)
 - [Job](docs/Job.md)
 - [JobOrder](docs/JobOrder.md)
 - [Keyword](docs/Keyword.md)
 - [Number](docs/Number.md)
 - [OpenSearch](docs/OpenSearch.md)
 - [Person](docs/Person.md)
 - [RasterTileURL](docs/RasterTileURL.md)
 - [Step](docs/Step.md)
 - [ValidationReport](docs/ValidationReport.md)
 - [ValidationResults](docs/ValidationResults.md)


## Documentation For Authorization

 All endpoints do not require authorization.


## Author

contact@gisaia.com

