import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::LookoutEquipment::InferenceScheduler`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html
 */
export interface CfnInferenceSchedulerProps {
    /**
     * `AWS::LookoutEquipment::InferenceScheduler.DataInputConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-datainputconfiguration
     */
    readonly dataInputConfiguration: any | cdk.IResolvable;
    /**
     * `AWS::LookoutEquipment::InferenceScheduler.DataOutputConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-dataoutputconfiguration
     */
    readonly dataOutputConfiguration: any | cdk.IResolvable;
    /**
     * `AWS::LookoutEquipment::InferenceScheduler.DataUploadFrequency`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-datauploadfrequency
     */
    readonly dataUploadFrequency: string;
    /**
     * `AWS::LookoutEquipment::InferenceScheduler.ModelName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-modelname
     */
    readonly modelName: string;
    /**
     * `AWS::LookoutEquipment::InferenceScheduler.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-rolearn
     */
    readonly roleArn: string;
    /**
     * `AWS::LookoutEquipment::InferenceScheduler.DataDelayOffsetInMinutes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-datadelayoffsetinminutes
     */
    readonly dataDelayOffsetInMinutes?: number;
    /**
     * `AWS::LookoutEquipment::InferenceScheduler.InferenceSchedulerName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-inferenceschedulername
     */
    readonly inferenceSchedulerName?: string;
    /**
     * `AWS::LookoutEquipment::InferenceScheduler.ServerSideKmsKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-serversidekmskeyid
     */
    readonly serverSideKmsKeyId?: string;
    /**
     * `AWS::LookoutEquipment::InferenceScheduler.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::LookoutEquipment::InferenceScheduler`.
 *
 * @external
 * @cloudformationResource AWS::LookoutEquipment::InferenceScheduler
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html
 */
export declare class CfnInferenceScheduler extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::LookoutEquipment::InferenceScheduler";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnInferenceScheduler;
    /**
     * @external
     * @cloudformationAttribute InferenceSchedulerArn
     */
    readonly attrInferenceSchedulerArn: string;
    /**
     * `AWS::LookoutEquipment::InferenceScheduler.DataInputConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-datainputconfiguration
     */
    dataInputConfiguration: any | cdk.IResolvable;
    /**
     * `AWS::LookoutEquipment::InferenceScheduler.DataOutputConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-dataoutputconfiguration
     */
    dataOutputConfiguration: any | cdk.IResolvable;
    /**
     * `AWS::LookoutEquipment::InferenceScheduler.DataUploadFrequency`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-datauploadfrequency
     */
    dataUploadFrequency: string;
    /**
     * `AWS::LookoutEquipment::InferenceScheduler.ModelName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-modelname
     */
    modelName: string;
    /**
     * `AWS::LookoutEquipment::InferenceScheduler.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-rolearn
     */
    roleArn: string;
    /**
     * `AWS::LookoutEquipment::InferenceScheduler.DataDelayOffsetInMinutes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-datadelayoffsetinminutes
     */
    dataDelayOffsetInMinutes: number | undefined;
    /**
     * `AWS::LookoutEquipment::InferenceScheduler.InferenceSchedulerName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-inferenceschedulername
     */
    inferenceSchedulerName: string | undefined;
    /**
     * `AWS::LookoutEquipment::InferenceScheduler.ServerSideKmsKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-serversidekmskeyid
     */
    serverSideKmsKeyId: string | undefined;
    /**
     * `AWS::LookoutEquipment::InferenceScheduler.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::LookoutEquipment::InferenceScheduler`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnInferenceSchedulerProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
