import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::StepFunctions::Activity`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-activity.html
 * @external
 */
export interface CfnActivityProps {
    /**
     * `AWS::StepFunctions::Activity.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-activity.html#cfn-stepfunctions-activity-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::StepFunctions::Activity.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-activity.html#cfn-stepfunctions-activity-tags
     * @external
     */
    readonly tags?: CfnActivity.TagsEntryProperty[];
}
/**
 * A CloudFormation `AWS::StepFunctions::Activity`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-activity.html
 * @external
 * @cloudformationResource AWS::StepFunctions::Activity
 */
export declare class CfnActivity extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::StepFunctions::Activity";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnActivity;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::StepFunctions::Activity.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-activity.html#cfn-stepfunctions-activity-name
     * @external
     */
    name: string;
    /**
     * `AWS::StepFunctions::Activity.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-activity.html#cfn-stepfunctions-activity-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::StepFunctions::Activity`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnActivityProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::StepFunctions::Activity`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-activity.html
 * @external
 * @cloudformationResource AWS::StepFunctions::Activity
 */
export declare namespace CfnActivity {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-activity-tagsentry.html
     * @external
     */
    interface TagsEntryProperty {
        /**
         * `CfnActivity.TagsEntryProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-activity-tagsentry.html#cfn-stepfunctions-activity-tagsentry-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnActivity.TagsEntryProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-activity-tagsentry.html#cfn-stepfunctions-activity-tagsentry-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * Properties for defining a `AWS::StepFunctions::StateMachine`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html
 * @external
 */
export interface CfnStateMachineProps {
    /**
     * `AWS::StepFunctions::StateMachine.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-rolearn
     * @external
     */
    readonly roleArn: string;
    /**
     * `AWS::StepFunctions::StateMachine.DefinitionS3Location`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-definitions3location
     * @external
     */
    readonly definitionS3Location?: CfnStateMachine.S3LocationProperty | cdk.IResolvable;
    /**
     * `AWS::StepFunctions::StateMachine.DefinitionString`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-definitionstring
     * @external
     */
    readonly definitionString?: string;
    /**
     * `AWS::StepFunctions::StateMachine.DefinitionSubstitutions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-definitionsubstitutions
     * @external
     */
    readonly definitionSubstitutions?: CfnStateMachine.DefinitionSubstitutionsProperty | cdk.IResolvable;
    /**
     * `AWS::StepFunctions::StateMachine.LoggingConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-loggingconfiguration
     * @external
     */
    readonly loggingConfiguration?: CfnStateMachine.LoggingConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::StepFunctions::StateMachine.StateMachineName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-statemachinename
     * @external
     */
    readonly stateMachineName?: string;
    /**
     * `AWS::StepFunctions::StateMachine.StateMachineType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-statemachinetype
     * @external
     */
    readonly stateMachineType?: string;
    /**
     * `AWS::StepFunctions::StateMachine.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-tags
     * @external
     */
    readonly tags?: CfnStateMachine.TagsEntryProperty[];
    /**
     * `AWS::StepFunctions::StateMachine.TracingConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-tracingconfiguration
     * @external
     */
    readonly tracingConfiguration?: CfnStateMachine.TracingConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::StepFunctions::StateMachine`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html
 * @external
 * @cloudformationResource AWS::StepFunctions::StateMachine
 */
export declare class CfnStateMachine extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::StepFunctions::StateMachine";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnStateMachine;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::StepFunctions::StateMachine.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-rolearn
     * @external
     */
    roleArn: string;
    /**
     * `AWS::StepFunctions::StateMachine.DefinitionS3Location`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-definitions3location
     * @external
     */
    definitionS3Location: CfnStateMachine.S3LocationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::StepFunctions::StateMachine.DefinitionString`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-definitionstring
     * @external
     */
    definitionString: string | undefined;
    /**
     * `AWS::StepFunctions::StateMachine.DefinitionSubstitutions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-definitionsubstitutions
     * @external
     */
    definitionSubstitutions: CfnStateMachine.DefinitionSubstitutionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::StepFunctions::StateMachine.LoggingConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-loggingconfiguration
     * @external
     */
    loggingConfiguration: CfnStateMachine.LoggingConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::StepFunctions::StateMachine.StateMachineName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-statemachinename
     * @external
     */
    stateMachineName: string | undefined;
    /**
     * `AWS::StepFunctions::StateMachine.StateMachineType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-statemachinetype
     * @external
     */
    stateMachineType: string | undefined;
    /**
     * `AWS::StepFunctions::StateMachine.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::StepFunctions::StateMachine.TracingConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html#cfn-stepfunctions-statemachine-tracingconfiguration
     * @external
     */
    tracingConfiguration: CfnStateMachine.TracingConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::StepFunctions::StateMachine`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnStateMachineProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::StepFunctions::StateMachine`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html
 * @external
 * @cloudformationResource AWS::StepFunctions::StateMachine
 */
export declare namespace CfnStateMachine {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-cloudwatchlogsloggroup.html
     * @external
     */
    interface CloudWatchLogsLogGroupProperty {
        /**
         * `CfnStateMachine.CloudWatchLogsLogGroupProperty.LogGroupArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-cloudwatchlogsloggroup.html#cfn-stepfunctions-statemachine-cloudwatchlogsloggroup-loggrouparn
         * @external
         */
        readonly logGroupArn?: string;
    }
}
/**
 * A CloudFormation `AWS::StepFunctions::StateMachine`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html
 * @external
 * @cloudformationResource AWS::StepFunctions::StateMachine
 */
export declare namespace CfnStateMachine {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-definitionsubstitutions.html
     * @external
     */
    interface DefinitionSubstitutionsProperty {
    }
}
/**
 * A CloudFormation `AWS::StepFunctions::StateMachine`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html
 * @external
 * @cloudformationResource AWS::StepFunctions::StateMachine
 */
export declare namespace CfnStateMachine {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-logdestination.html
     * @external
     */
    interface LogDestinationProperty {
        /**
         * `CfnStateMachine.LogDestinationProperty.CloudWatchLogsLogGroup`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-logdestination.html#cfn-stepfunctions-statemachine-logdestination-cloudwatchlogsloggroup
         * @external
         */
        readonly cloudWatchLogsLogGroup?: CfnStateMachine.CloudWatchLogsLogGroupProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::StepFunctions::StateMachine`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html
 * @external
 * @cloudformationResource AWS::StepFunctions::StateMachine
 */
export declare namespace CfnStateMachine {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-loggingconfiguration.html
     * @external
     */
    interface LoggingConfigurationProperty {
        /**
         * `CfnStateMachine.LoggingConfigurationProperty.Destinations`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-loggingconfiguration.html#cfn-stepfunctions-statemachine-loggingconfiguration-destinations
         * @external
         */
        readonly destinations?: Array<CfnStateMachine.LogDestinationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnStateMachine.LoggingConfigurationProperty.IncludeExecutionData`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-loggingconfiguration.html#cfn-stepfunctions-statemachine-loggingconfiguration-includeexecutiondata
         * @external
         */
        readonly includeExecutionData?: boolean | cdk.IResolvable;
        /**
         * `CfnStateMachine.LoggingConfigurationProperty.Level`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-loggingconfiguration.html#cfn-stepfunctions-statemachine-loggingconfiguration-level
         * @external
         */
        readonly level?: string;
    }
}
/**
 * A CloudFormation `AWS::StepFunctions::StateMachine`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html
 * @external
 * @cloudformationResource AWS::StepFunctions::StateMachine
 */
export declare namespace CfnStateMachine {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-s3location.html
     * @external
     */
    interface S3LocationProperty {
        /**
         * `CfnStateMachine.S3LocationProperty.Bucket`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-s3location.html#cfn-stepfunctions-statemachine-s3location-bucket
         * @external
         */
        readonly bucket: string;
        /**
         * `CfnStateMachine.S3LocationProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-s3location.html#cfn-stepfunctions-statemachine-s3location-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnStateMachine.S3LocationProperty.Version`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-s3location.html#cfn-stepfunctions-statemachine-s3location-version
         * @external
         */
        readonly version?: string;
    }
}
/**
 * A CloudFormation `AWS::StepFunctions::StateMachine`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html
 * @external
 * @cloudformationResource AWS::StepFunctions::StateMachine
 */
export declare namespace CfnStateMachine {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-tagsentry.html
     * @external
     */
    interface TagsEntryProperty {
        /**
         * `CfnStateMachine.TagsEntryProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-tagsentry.html#cfn-stepfunctions-statemachine-tagsentry-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnStateMachine.TagsEntryProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-tagsentry.html#cfn-stepfunctions-statemachine-tagsentry-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::StepFunctions::StateMachine`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html
 * @external
 * @cloudformationResource AWS::StepFunctions::StateMachine
 */
export declare namespace CfnStateMachine {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-tracingconfiguration.html
     * @external
     */
    interface TracingConfigurationProperty {
        /**
         * `CfnStateMachine.TracingConfigurationProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-tracingconfiguration.html#cfn-stepfunctions-statemachine-tracingconfiguration-enabled
         * @external
         */
        readonly enabled?: boolean | cdk.IResolvable;
    }
}
