"""
    Airflow API (Stable)

    Apache Airflow management API.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: zach.z.liu@gmail.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from airflow_python_sdk.api_client import ApiClient, Endpoint
from airflow_python_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from airflow_python_sdk.model.error import Error
from airflow_python_sdk.model.x_com import XCom
from airflow_python_sdk.model.x_com_collection import XComCollection


class XComApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __delete_x_com_value(
            self,
            dag_id,
            task_id,
            execution_date,
            key,
            **kwargs
        ):
            """Delete an XCom entry  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_x_com_value(dag_id, task_id, execution_date, key, async_req=True)
            >>> result = thread.get()

            Args:
                dag_id (int): The DAG ID.
                task_id (int): The Task ID.
                execution_date (datetime): The date-time notation as defined by [RFC 3339, section 5.6](https://tools.ietf.org/html/rfc3339#section-5.6), E.G. `2017-07-21T17:32:28Z` 
                key (str): The XCom Key.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['dag_id'] = \
                dag_id
            kwargs['task_id'] = \
                task_id
            kwargs['execution_date'] = \
                execution_date
            kwargs['key'] = \
                key
            return self.call_with_http_info(**kwargs)

        self.delete_x_com_value = Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/dags/{dag_id}/taskInstances/{task_id}/{execution_date}/xcomValues/{key}',
                'operation_id': 'delete_x_com_value',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'dag_id',
                    'task_id',
                    'execution_date',
                    'key',
                ],
                'required': [
                    'dag_id',
                    'task_id',
                    'execution_date',
                    'key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'dag_id':
                        (int,),
                    'task_id':
                        (int,),
                    'execution_date':
                        (datetime,),
                    'key':
                        (str,),
                },
                'attribute_map': {
                    'dag_id': 'dag_id',
                    'task_id': 'task_id',
                    'execution_date': 'execution_date',
                    'key': 'key',
                },
                'location_map': {
                    'dag_id': 'path',
                    'task_id': 'path',
                    'execution_date': 'path',
                    'key': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_x_com_value
        )

        def __get_x_com_value(
            self,
            dag_id,
            task_id,
            execution_date,
            key,
            **kwargs
        ):
            """Get an XCom entry  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_x_com_value(dag_id, task_id, execution_date, key, async_req=True)
            >>> result = thread.get()

            Args:
                dag_id (int): The DAG ID.
                task_id (int): The Task ID.
                execution_date (datetime): The date-time notation as defined by [RFC 3339, section 5.6](https://tools.ietf.org/html/rfc3339#section-5.6), E.G. `2017-07-21T17:32:28Z` 
                key (str): The XCom Key.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                XCom
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['dag_id'] = \
                dag_id
            kwargs['task_id'] = \
                task_id
            kwargs['execution_date'] = \
                execution_date
            kwargs['key'] = \
                key
            return self.call_with_http_info(**kwargs)

        self.get_x_com_value = Endpoint(
            settings={
                'response_type': (XCom,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/dags/{dag_id}/taskInstances/{task_id}/{execution_date}/xcomValues/{key}',
                'operation_id': 'get_x_com_value',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'dag_id',
                    'task_id',
                    'execution_date',
                    'key',
                ],
                'required': [
                    'dag_id',
                    'task_id',
                    'execution_date',
                    'key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'dag_id':
                        (int,),
                    'task_id':
                        (int,),
                    'execution_date':
                        (datetime,),
                    'key':
                        (str,),
                },
                'attribute_map': {
                    'dag_id': 'dag_id',
                    'task_id': 'task_id',
                    'execution_date': 'execution_date',
                    'key': 'key',
                },
                'location_map': {
                    'dag_id': 'path',
                    'task_id': 'path',
                    'execution_date': 'path',
                    'key': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_x_com_value
        )

        def __get_x_com_values(
            self,
            dag_id,
            task_id,
            execution_date,
            **kwargs
        ):
            """Get all XCom values  # noqa: E501

            This endpoint support reading resources across multiple Task Instances by specifying a \"-\" as a `dag_id`, `task_id` and `execution_date`.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_x_com_values(dag_id, task_id, execution_date, async_req=True)
            >>> result = thread.get()

            Args:
                dag_id (int): The DAG ID.
                task_id (int): The Task ID.
                execution_date (datetime): The date-time notation as defined by [RFC 3339, section 5.6](https://tools.ietf.org/html/rfc3339#section-5.6), E.G. `2017-07-21T17:32:28Z` 

            Keyword Args:
                limit (int): The numbers of items to return.. [optional] if omitted the server will use the default value of 100
                offset (int): The number of items to skip before starting to collect the result set.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                XComCollection
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['dag_id'] = \
                dag_id
            kwargs['task_id'] = \
                task_id
            kwargs['execution_date'] = \
                execution_date
            return self.call_with_http_info(**kwargs)

        self.get_x_com_values = Endpoint(
            settings={
                'response_type': (XComCollection,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/dags/{dag_id}/taskInstances/{task_id}/{execution_date}/xcomValues',
                'operation_id': 'get_x_com_values',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'dag_id',
                    'task_id',
                    'execution_date',
                    'limit',
                    'offset',
                ],
                'required': [
                    'dag_id',
                    'task_id',
                    'execution_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'limit',
                    'offset',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_minimum': 1,
                    },
                    ('offset',): {

                        'inclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'dag_id':
                        (int,),
                    'task_id':
                        (int,),
                    'execution_date':
                        (datetime,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'dag_id': 'dag_id',
                    'task_id': 'task_id',
                    'execution_date': 'execution_date',
                    'limit': 'limit',
                    'offset': 'offset',
                },
                'location_map': {
                    'dag_id': 'path',
                    'task_id': 'path',
                    'execution_date': 'path',
                    'limit': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_x_com_values
        )

        def __update_x_com_value(
            self,
            dag_id,
            task_id,
            execution_date,
            key,
            x_com,
            **kwargs
        ):
            """Update an XCom entry  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_x_com_value(dag_id, task_id, execution_date, key, x_com, async_req=True)
            >>> result = thread.get()

            Args:
                dag_id (int): The DAG ID.
                task_id (int): The Task ID.
                execution_date (datetime): The date-time notation as defined by [RFC 3339, section 5.6](https://tools.ietf.org/html/rfc3339#section-5.6), E.G. `2017-07-21T17:32:28Z` 
                key (str): The XCom Key.
                x_com (XCom):

            Keyword Args:
                update_mask ([str]): The fields to update on the connection (connection, pool etc). If absent or empty, all modifiable fields are updated. A comma-separated list of fully qualified names of fields. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                XCom
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['dag_id'] = \
                dag_id
            kwargs['task_id'] = \
                task_id
            kwargs['execution_date'] = \
                execution_date
            kwargs['key'] = \
                key
            kwargs['x_com'] = \
                x_com
            return self.call_with_http_info(**kwargs)

        self.update_x_com_value = Endpoint(
            settings={
                'response_type': (XCom,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/dags/{dag_id}/taskInstances/{task_id}/{execution_date}/xcomValues/{key}',
                'operation_id': 'update_x_com_value',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'dag_id',
                    'task_id',
                    'execution_date',
                    'key',
                    'x_com',
                    'update_mask',
                ],
                'required': [
                    'dag_id',
                    'task_id',
                    'execution_date',
                    'key',
                    'x_com',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'dag_id':
                        (int,),
                    'task_id':
                        (int,),
                    'execution_date':
                        (datetime,),
                    'key':
                        (str,),
                    'x_com':
                        (XCom,),
                    'update_mask':
                        ([str],),
                },
                'attribute_map': {
                    'dag_id': 'dag_id',
                    'task_id': 'task_id',
                    'execution_date': 'execution_date',
                    'key': 'key',
                    'update_mask': 'update_mask',
                },
                'location_map': {
                    'dag_id': 'path',
                    'task_id': 'path',
                    'execution_date': 'path',
                    'key': 'path',
                    'x_com': 'body',
                    'update_mask': 'query',
                },
                'collection_format_map': {
                    'update_mask': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_x_com_value
        )

        def __update_x_com_values(
            self,
            dag_id,
            task_id,
            execution_date,
            x_com,
            **kwargs
        ):
            """Create an XCom entry  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_x_com_values(dag_id, task_id, execution_date, x_com, async_req=True)
            >>> result = thread.get()

            Args:
                dag_id (int): The DAG ID.
                task_id (int): The Task ID.
                execution_date (datetime): The date-time notation as defined by [RFC 3339, section 5.6](https://tools.ietf.org/html/rfc3339#section-5.6), E.G. `2017-07-21T17:32:28Z` 
                x_com (XCom):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                XCom
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['dag_id'] = \
                dag_id
            kwargs['task_id'] = \
                task_id
            kwargs['execution_date'] = \
                execution_date
            kwargs['x_com'] = \
                x_com
            return self.call_with_http_info(**kwargs)

        self.update_x_com_values = Endpoint(
            settings={
                'response_type': (XCom,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/dags/{dag_id}/taskInstances/{task_id}/{execution_date}/xcomValues',
                'operation_id': 'update_x_com_values',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'dag_id',
                    'task_id',
                    'execution_date',
                    'x_com',
                ],
                'required': [
                    'dag_id',
                    'task_id',
                    'execution_date',
                    'x_com',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'dag_id':
                        (int,),
                    'task_id':
                        (int,),
                    'execution_date':
                        (datetime,),
                    'x_com':
                        (XCom,),
                },
                'attribute_map': {
                    'dag_id': 'dag_id',
                    'task_id': 'task_id',
                    'execution_date': 'execution_date',
                },
                'location_map': {
                    'dag_id': 'path',
                    'task_id': 'path',
                    'execution_date': 'path',
                    'x_com': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_x_com_values
        )
