# Generated by Django 3.1.4 on 2020-12-30 08:53

from uuid import uuid4
from django.db import migrations


def generate_identifier(apps, schema_editor):
    # We can't import the Person model directly as it may be a newer
    # version than this migration expects. We use the historical version.
    Identifier = apps.get_model('analytics', 'AnalyticsIdentifier')
    identifier = Identifier()
    identifier.id = 1
    identifier.save()


def zero_identifier(apps, schema_editor):
    # Have to define some code to remove this identifier
    # In case of migration rollback?
    Identifier = apps.get_model('analytics', 'AnalyticsIdentifier')
    Identifier.objects.filter(id=1).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('analytics', '0002_add_AA_Team_Token'),
    ]

    operations = [migrations.RunPython(generate_identifier, zero_identifier)
                    ]
