"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import axonclient.protos.common_pb2
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class GetFirstTokenRequest(google.protobuf.message.Message):
    """Request message to receive the first Token (Tail Token) of the Event Stream"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    def __init__(
        self,
    ) -> None: ...

global___GetFirstTokenRequest = GetFirstTokenRequest

class GetLastTokenRequest(google.protobuf.message.Message):
    """Request message to receive the last Token (Head Token) of the Event Stream"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    def __init__(
        self,
    ) -> None: ...

global___GetLastTokenRequest = GetLastTokenRequest

class GetTokenAtRequest(google.protobuf.message.Message):
    """Request message to receive the Token that starts streaming events from the given timestamp"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    INSTANT_FIELD_NUMBER: builtins.int
    instant: builtins.int
    """Timestamp expressed as milliseconds since epoch"""

    def __init__(
        self,
        *,
        instant: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["instant", b"instant"]
    ) -> None: ...

global___GetTokenAtRequest = GetTokenAtRequest

class TrackingToken(google.protobuf.message.Message):
    """Message containing the information necessary to track the position of events in the Event Stream"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TOKEN_FIELD_NUMBER: builtins.int
    token: builtins.int
    """The value of the Token"""

    def __init__(
        self,
        *,
        token: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["token", b"token"]
    ) -> None: ...

global___TrackingToken = TrackingToken

class EventWithToken(google.protobuf.message.Message):
    """Message wrapping an Event and a Tracking Token"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TOKEN_FIELD_NUMBER: builtins.int
    EVENT_FIELD_NUMBER: builtins.int
    token: builtins.int
    """The Token representing the position of this Event in the Stream"""

    @property
    def event(self) -> global___Event:
        """The actual Event Message"""
        pass
    def __init__(
        self,
        *,
        token: builtins.int = ...,
        event: typing.Optional[global___Event] = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["event", b"event"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal["event", b"event", "token", b"token"],
    ) -> None: ...

global___EventWithToken = EventWithToken

class QueryEventsRequest(google.protobuf.message.Message):
    """Message providing the parameters for executing a Query against AxonServer."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    QUERY_FIELD_NUMBER: builtins.int
    NUMBER_OF_PERMITS_FIELD_NUMBER: builtins.int
    LIVE_EVENTS_FIELD_NUMBER: builtins.int
    query: typing.Text
    """The query to execute against the Event Stream"""

    number_of_permits: builtins.int
    """The number of results AxonServer may send before new permits need to be provided"""

    live_events: builtins.bool
    """Whether to keep the query running against incoming events once the Head of the Stream is reached"""

    def __init__(
        self,
        *,
        query: typing.Text = ...,
        number_of_permits: builtins.int = ...,
        live_events: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "live_events",
            b"live_events",
            "number_of_permits",
            b"number_of_permits",
            "query",
            b"query",
        ],
    ) -> None: ...

global___QueryEventsRequest = QueryEventsRequest

class QueryEventsResponse(google.protobuf.message.Message):
    """A message describing a response to a Query request"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    COLUMNS_FIELD_NUMBER: builtins.int
    ROW_FIELD_NUMBER: builtins.int
    FILES_COMPLETED_FIELD_NUMBER: builtins.int
    @property
    def columns(self) -> global___ColumnsResponse:
        """Provided when the response contains the names of the columns the response contains. This message typically arrives first."""
        pass
    @property
    def row(self) -> global___RowResponse:
        """Provided when the response message contains results of the Query"""
        pass
    @property
    def files_completed(self) -> global___Confirmation:
        """Provided when all historic events have been included in the query results"""
        pass
    def __init__(
        self,
        *,
        columns: typing.Optional[global___ColumnsResponse] = ...,
        row: typing.Optional[global___RowResponse] = ...,
        files_completed: typing.Optional[global___Confirmation] = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "columns",
            b"columns",
            "data",
            b"data",
            "files_completed",
            b"files_completed",
            "row",
            b"row",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "columns",
            b"columns",
            "data",
            b"data",
            "files_completed",
            b"files_completed",
            "row",
            b"row",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["data", b"data"]
    ) -> typing.Optional[
        typing_extensions.Literal["columns", "row", "files_completed"]
    ]: ...

global___QueryEventsResponse = QueryEventsResponse

class ColumnsResponse(google.protobuf.message.Message):
    """Message containing the names of the columns returned in a Query"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    COLUMN_FIELD_NUMBER: builtins.int
    @property
    def column(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """The names of the columns provided in the query"""
        pass
    def __init__(
        self,
        *,
        column: typing.Optional[typing.Iterable[typing.Text]] = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["column", b"column"]
    ) -> None: ...

global___ColumnsResponse = ColumnsResponse

class RowResponse(google.protobuf.message.Message):
    """Message providing Query Result data"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class ValuesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> global___QueryValue: ...
        def __init__(
            self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[global___QueryValue] = ...,
        ) -> None: ...
        def HasField(
            self, field_name: typing_extensions.Literal["value", b"value"]
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal["key", b"key", "value", b"value"],
        ) -> None: ...

    ID_VALUES_FIELD_NUMBER: builtins.int
    SORT_VALUES_FIELD_NUMBER: builtins.int
    VALUES_FIELD_NUMBER: builtins.int
    @property
    def id_values(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___QueryValue
    ]:
        """The values which, when combined, uniquely update this row. Any previously received values with the same identifiers should be replaced with this value"""
        pass
    @property
    def sort_values(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___QueryValue
    ]:
        """The sorting values to use when sorting this response compared to the others."""
        pass
    @property
    def values(
        self,
    ) -> google.protobuf.internal.containers.MessageMap[
        typing.Text, global___QueryValue
    ]:
        """The actual data values for each of the columns, as a column name -> value mapping"""
        pass
    def __init__(
        self,
        *,
        id_values: typing.Optional[typing.Iterable[global___QueryValue]] = ...,
        sort_values: typing.Optional[typing.Iterable[global___QueryValue]] = ...,
        values: typing.Optional[typing.Mapping[typing.Text, global___QueryValue]] = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "id_values",
            b"id_values",
            "sort_values",
            b"sort_values",
            "values",
            b"values",
        ],
    ) -> None: ...

global___RowResponse = RowResponse

class ReadHighestSequenceNrRequest(google.protobuf.message.Message):
    """Describes the combination of an Aggregate Identifier and first expected Sequence number when opening an Aggregate-specific Event Stream"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    AGGREGATE_ID_FIELD_NUMBER: builtins.int
    FROM_SEQUENCE_NR_FIELD_NUMBER: builtins.int
    aggregate_id: typing.Text
    """The Identifier of the Aggregate for which to load events"""

    from_sequence_nr: builtins.int
    """The Sequence Number of the first event expected"""

    def __init__(
        self,
        *,
        aggregate_id: typing.Text = ...,
        from_sequence_nr: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "aggregate_id", b"aggregate_id", "from_sequence_nr", b"from_sequence_nr"
        ],
    ) -> None: ...

global___ReadHighestSequenceNrRequest = ReadHighestSequenceNrRequest

class ReadHighestSequenceNrResponse(google.protobuf.message.Message):
    """The highest Sequence Number found for the provided request"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TO_SEQUENCE_NR_FIELD_NUMBER: builtins.int
    to_sequence_nr: builtins.int
    """The sequence number of the latest event"""

    def __init__(
        self,
        *,
        to_sequence_nr: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["to_sequence_nr", b"to_sequence_nr"]
    ) -> None: ...

global___ReadHighestSequenceNrResponse = ReadHighestSequenceNrResponse

class Confirmation(google.protobuf.message.Message):
    """A confirmation to a request from the client"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SUCCESS_FIELD_NUMBER: builtins.int
    success: builtins.bool
    """True when successful, otherwise false"""

    def __init__(
        self,
        *,
        success: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["success", b"success"]
    ) -> None: ...

global___Confirmation = Confirmation

class GetAggregateEventsRequest(google.protobuf.message.Message):
    """Request describing the desire to read events for a specific Aggregate"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    AGGREGATE_ID_FIELD_NUMBER: builtins.int
    INITIAL_SEQUENCE_FIELD_NUMBER: builtins.int
    ALLOW_SNAPSHOTS_FIELD_NUMBER: builtins.int
    aggregate_id: typing.Text
    """The identifier of the aggregate to read events for"""

    initial_sequence: builtins.int
    """The sequence number of the first event to receive"""

    allow_snapshots: builtins.bool
    """Whether a snapshot may be returned as first element in the stream"""

    def __init__(
        self,
        *,
        aggregate_id: typing.Text = ...,
        initial_sequence: builtins.int = ...,
        allow_snapshots: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "aggregate_id",
            b"aggregate_id",
            "allow_snapshots",
            b"allow_snapshots",
            "initial_sequence",
            b"initial_sequence",
        ],
    ) -> None: ...

global___GetAggregateEventsRequest = GetAggregateEventsRequest

class GetAggregateSnapshotsRequest(google.protobuf.message.Message):
    """Request message to retrieve Snapshot Events for a specific Aggregate instance"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    AGGREGATE_ID_FIELD_NUMBER: builtins.int
    INITIAL_SEQUENCE_FIELD_NUMBER: builtins.int
    MAX_SEQUENCE_FIELD_NUMBER: builtins.int
    MAX_RESULTS_FIELD_NUMBER: builtins.int
    aggregate_id: typing.Text
    """The identifier to fetch the snapshots for"""

    initial_sequence: builtins.int
    """The minimal sequence number of the snapshots to retrieve"""

    max_sequence: builtins.int
    """The maximum sequence number of the snapshots to retrieve"""

    max_results: builtins.int
    """The maximum number of results to stream"""

    def __init__(
        self,
        *,
        aggregate_id: typing.Text = ...,
        initial_sequence: builtins.int = ...,
        max_sequence: builtins.int = ...,
        max_results: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "aggregate_id",
            b"aggregate_id",
            "initial_sequence",
            b"initial_sequence",
            "max_results",
            b"max_results",
            "max_sequence",
            b"max_sequence",
        ],
    ) -> None: ...

global___GetAggregateSnapshotsRequest = GetAggregateSnapshotsRequest

class GetEventsRequest(google.protobuf.message.Message):
    """Request message to open an Event Stream from the Event Store."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TRACKING_TOKEN_FIELD_NUMBER: builtins.int
    NUMBER_OF_PERMITS_FIELD_NUMBER: builtins.int
    CLIENT_ID_FIELD_NUMBER: builtins.int
    COMPONENT_NAME_FIELD_NUMBER: builtins.int
    PROCESSOR_FIELD_NUMBER: builtins.int
    BLACKLIST_FIELD_NUMBER: builtins.int
    tracking_token: builtins.int
    """The token to start streaming from"""

    number_of_permits: builtins.int
    """The number of messages the server may send before it needs to wait for more permits"""

    client_id: typing.Text
    """The unique identifier of this client instance. Used for monitoring."""

    component_name: typing.Text
    """The component name of this client instance. Used for monitoring."""

    processor: typing.Text
    """The name of the processor requesting this stream. Used for monitoring."""

    @property
    def blacklist(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___PayloadDescription
    ]:
        """An enumeration of payload types that need to be blacklisted. The Server will stop sending messages of these
        types in order to reduce I/O. Note that the Server may occasionally send a blacklisted message to prevent
        time-outs and stale tokens on clients.
        """
        pass
    def __init__(
        self,
        *,
        tracking_token: builtins.int = ...,
        number_of_permits: builtins.int = ...,
        client_id: typing.Text = ...,
        component_name: typing.Text = ...,
        processor: typing.Text = ...,
        blacklist: typing.Optional[typing.Iterable[global___PayloadDescription]] = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "blacklist",
            b"blacklist",
            "client_id",
            b"client_id",
            "component_name",
            b"component_name",
            "number_of_permits",
            b"number_of_permits",
            "processor",
            b"processor",
            "tracking_token",
            b"tracking_token",
        ],
    ) -> None: ...

global___GetEventsRequest = GetEventsRequest

class Event(google.protobuf.message.Message):
    """Message containing the information of an Event"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class MetaDataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> axonclient.protos.common_pb2.MetaDataValue: ...
        def __init__(
            self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[axonclient.protos.common_pb2.MetaDataValue] = ...,
        ) -> None: ...
        def HasField(
            self, field_name: typing_extensions.Literal["value", b"value"]
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal["key", b"key", "value", b"value"],
        ) -> None: ...

    MESSAGE_IDENTIFIER_FIELD_NUMBER: builtins.int
    AGGREGATE_IDENTIFIER_FIELD_NUMBER: builtins.int
    AGGREGATE_SEQUENCE_NUMBER_FIELD_NUMBER: builtins.int
    AGGREGATE_TYPE_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    META_DATA_FIELD_NUMBER: builtins.int
    SNAPSHOT_FIELD_NUMBER: builtins.int
    message_identifier: typing.Text
    """The unique identifier of this event"""

    aggregate_identifier: typing.Text
    """The identifier of the Aggregate instance that published this event, if any"""

    aggregate_sequence_number: builtins.int
    """The sequence number of the Event in the Aggregate instance that published it, if any"""

    aggregate_type: typing.Text
    """The Type of the Aggregate instance that published this Event, if any"""

    timestamp: builtins.int
    """The timestamp of the Event"""

    @property
    def payload(self) -> axonclient.protos.common_pb2.SerializedObject:
        """The Payload of the Event"""
        pass
    @property
    def meta_data(
        self,
    ) -> google.protobuf.internal.containers.MessageMap[
        typing.Text, axonclient.protos.common_pb2.MetaDataValue
    ]:
        """The Meta Data of the Event"""
        pass
    snapshot: builtins.bool
    """Flag indicating whether the Event is a snapshot Event"""

    def __init__(
        self,
        *,
        message_identifier: typing.Text = ...,
        aggregate_identifier: typing.Text = ...,
        aggregate_sequence_number: builtins.int = ...,
        aggregate_type: typing.Text = ...,
        timestamp: builtins.int = ...,
        payload: typing.Optional[axonclient.protos.common_pb2.SerializedObject] = ...,
        meta_data: typing.Optional[
            typing.Mapping[typing.Text, axonclient.protos.common_pb2.MetaDataValue]
        ] = ...,
        snapshot: builtins.bool = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["payload", b"payload"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "aggregate_identifier",
            b"aggregate_identifier",
            "aggregate_sequence_number",
            b"aggregate_sequence_number",
            "aggregate_type",
            b"aggregate_type",
            "message_identifier",
            b"message_identifier",
            "meta_data",
            b"meta_data",
            "payload",
            b"payload",
            "snapshot",
            b"snapshot",
            "timestamp",
            b"timestamp",
        ],
    ) -> None: ...

global___Event = Event

class QueryValue(google.protobuf.message.Message):
    """Value used in Query Responses to represent a value in its original type"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TEXT_VALUE_FIELD_NUMBER: builtins.int
    NUMBER_VALUE_FIELD_NUMBER: builtins.int
    BOOLEAN_VALUE_FIELD_NUMBER: builtins.int
    DOUBLE_VALUE_FIELD_NUMBER: builtins.int
    text_value: typing.Text
    """The text value"""

    number_value: builtins.int
    """The (64 bits) integer value"""

    boolean_value: builtins.bool
    """The boolean value"""

    double_value: builtins.float
    """The (64 bits) floating point value"""

    def __init__(
        self,
        *,
        text_value: typing.Text = ...,
        number_value: builtins.int = ...,
        boolean_value: builtins.bool = ...,
        double_value: builtins.float = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "boolean_value",
            b"boolean_value",
            "data",
            b"data",
            "double_value",
            b"double_value",
            "number_value",
            b"number_value",
            "text_value",
            b"text_value",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "boolean_value",
            b"boolean_value",
            "data",
            b"data",
            "double_value",
            b"double_value",
            "number_value",
            b"number_value",
            "text_value",
            b"text_value",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["data", b"data"]
    ) -> typing.Optional[
        typing_extensions.Literal[
            "text_value", "number_value", "boolean_value", "double_value"
        ]
    ]: ...

global___QueryValue = QueryValue

class PayloadDescription(google.protobuf.message.Message):
    """Description of a Payload Type"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TYPE_FIELD_NUMBER: builtins.int
    REVISION_FIELD_NUMBER: builtins.int
    type: typing.Text
    """The type identifier of the Payload"""

    revision: typing.Text
    """The revision of the Payload Type"""

    def __init__(
        self,
        *,
        type: typing.Text = ...,
        revision: typing.Text = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal["revision", b"revision", "type", b"type"],
    ) -> None: ...

global___PayloadDescription = PayloadDescription
