"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import axonclient.protos.common_pb2
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class CommandProviderOutbound(google.protobuf.message.Message):
    """An instruction from the components that provides the Command Handler towards AxonServer."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SUBSCRIBE_FIELD_NUMBER: builtins.int
    UNSUBSCRIBE_FIELD_NUMBER: builtins.int
    FLOW_CONTROL_FIELD_NUMBER: builtins.int
    COMMAND_RESPONSE_FIELD_NUMBER: builtins.int
    ACK_FIELD_NUMBER: builtins.int
    INSTRUCTION_ID_FIELD_NUMBER: builtins.int
    @property
    def subscribe(self) -> global___CommandSubscription:
        """Instruction to subscribe this component as handler of a specific type of command"""
        pass
    @property
    def unsubscribe(self) -> global___CommandSubscription:
        """Instruction to unsubscribe this component as handler of a specific type of command"""
        pass
    @property
    def flow_control(self) -> axonclient.protos.common_pb2.FlowControl:
        """Instruction to increase the number of instructions AxonServer may send to this component"""
        pass
    @property
    def command_response(self) -> global___CommandResponse:
        """Sends a result of Command processing"""
        pass
    @property
    def ack(self) -> axonclient.protos.common_pb2.InstructionAck:
        """Acknowledgement of previously sent instruction via inbound stream"""
        pass
    instruction_id: typing.Text
    """Instruction identifier. If this identifier is set, this instruction will be acknowledged via inbound stream"""

    def __init__(
        self,
        *,
        subscribe: typing.Optional[global___CommandSubscription] = ...,
        unsubscribe: typing.Optional[global___CommandSubscription] = ...,
        flow_control: typing.Optional[axonclient.protos.common_pb2.FlowControl] = ...,
        command_response: typing.Optional[global___CommandResponse] = ...,
        ack: typing.Optional[axonclient.protos.common_pb2.InstructionAck] = ...,
        instruction_id: typing.Text = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "ack",
            b"ack",
            "command_response",
            b"command_response",
            "flow_control",
            b"flow_control",
            "request",
            b"request",
            "subscribe",
            b"subscribe",
            "unsubscribe",
            b"unsubscribe",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "ack",
            b"ack",
            "command_response",
            b"command_response",
            "flow_control",
            b"flow_control",
            "instruction_id",
            b"instruction_id",
            "request",
            b"request",
            "subscribe",
            b"subscribe",
            "unsubscribe",
            b"unsubscribe",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["request", b"request"]
    ) -> typing.Optional[
        typing_extensions.Literal[
            "subscribe", "unsubscribe", "flow_control", "command_response", "ack"
        ]
    ]: ...

global___CommandProviderOutbound = CommandProviderOutbound

class CommandProviderInbound(google.protobuf.message.Message):
    """An instruction or confirmation from AxonServer towards the component that provides the Command Handler"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ACK_FIELD_NUMBER: builtins.int
    COMMAND_FIELD_NUMBER: builtins.int
    INSTRUCTION_ID_FIELD_NUMBER: builtins.int
    @property
    def ack(self) -> axonclient.protos.common_pb2.InstructionAck:
        """Acknowledgement of previously sent instruction via outbound stream"""
        pass
    @property
    def command(self) -> global___Command:
        """A command for this component to process"""
        pass
    instruction_id: typing.Text
    """Instruction identifier. If this identifier is set, this instruction will be acknowledged via outbound stream"""

    def __init__(
        self,
        *,
        ack: typing.Optional[axonclient.protos.common_pb2.InstructionAck] = ...,
        command: typing.Optional[global___Command] = ...,
        instruction_id: typing.Text = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "ack", b"ack", "command", b"command", "request", b"request"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "ack",
            b"ack",
            "command",
            b"command",
            "instruction_id",
            b"instruction_id",
            "request",
            b"request",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["request", b"request"]
    ) -> typing.Optional[typing_extensions.Literal["ack", "command"]]: ...

global___CommandProviderInbound = CommandProviderInbound

class Command(google.protobuf.message.Message):
    """A message representing a Command that needs to be routed to a component capable of handling it"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class MetaDataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> axonclient.protos.common_pb2.MetaDataValue: ...
        def __init__(
            self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[axonclient.protos.common_pb2.MetaDataValue] = ...,
        ) -> None: ...
        def HasField(
            self, field_name: typing_extensions.Literal["value", b"value"]
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal["key", b"key", "value", b"value"],
        ) -> None: ...

    MESSAGE_IDENTIFIER_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    META_DATA_FIELD_NUMBER: builtins.int
    PROCESSING_INSTRUCTIONS_FIELD_NUMBER: builtins.int
    CLIENT_ID_FIELD_NUMBER: builtins.int
    COMPONENT_NAME_FIELD_NUMBER: builtins.int
    message_identifier: typing.Text
    """The unique identifier of the Command Message"""

    name: typing.Text
    """The name of the command, used for routing it to a destination capable of handling it"""

    timestamp: builtins.int
    """The time at which the command was dispatched"""

    @property
    def payload(self) -> axonclient.protos.common_pb2.SerializedObject:
        """The payload of the Command, providing details on the instructions for the recipient"""
        pass
    @property
    def meta_data(
        self,
    ) -> google.protobuf.internal.containers.MessageMap[
        typing.Text, axonclient.protos.common_pb2.MetaDataValue
    ]:
        """Meta Data entries of the Command Message, providing contextual information to the recipient"""
        pass
    @property
    def processing_instructions(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        axonclient.protos.common_pb2.ProcessingInstruction
    ]:
        """Instructions for AxonServer when routing this Command Message"""
        pass
    client_id: typing.Text
    """The unique identifier of the component dispatching this message"""

    component_name: typing.Text
    """The name/type of the component dispatching this message"""

    def __init__(
        self,
        *,
        message_identifier: typing.Text = ...,
        name: typing.Text = ...,
        timestamp: builtins.int = ...,
        payload: typing.Optional[axonclient.protos.common_pb2.SerializedObject] = ...,
        meta_data: typing.Optional[
            typing.Mapping[typing.Text, axonclient.protos.common_pb2.MetaDataValue]
        ] = ...,
        processing_instructions: typing.Optional[
            typing.Iterable[axonclient.protos.common_pb2.ProcessingInstruction]
        ] = ...,
        client_id: typing.Text = ...,
        component_name: typing.Text = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["payload", b"payload"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "client_id",
            b"client_id",
            "component_name",
            b"component_name",
            "message_identifier",
            b"message_identifier",
            "meta_data",
            b"meta_data",
            "name",
            b"name",
            "payload",
            b"payload",
            "processing_instructions",
            b"processing_instructions",
            "timestamp",
            b"timestamp",
        ],
    ) -> None: ...

global___Command = Command

class CommandResponse(google.protobuf.message.Message):
    """Message representing the result of Command Handler execution"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class MetaDataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> axonclient.protos.common_pb2.MetaDataValue: ...
        def __init__(
            self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[axonclient.protos.common_pb2.MetaDataValue] = ...,
        ) -> None: ...
        def HasField(
            self, field_name: typing_extensions.Literal["value", b"value"]
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal["key", b"key", "value", b"value"],
        ) -> None: ...

    MESSAGE_IDENTIFIER_FIELD_NUMBER: builtins.int
    ERROR_CODE_FIELD_NUMBER: builtins.int
    ERROR_MESSAGE_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    META_DATA_FIELD_NUMBER: builtins.int
    PROCESSING_INSTRUCTIONS_FIELD_NUMBER: builtins.int
    REQUEST_IDENTIFIER_FIELD_NUMBER: builtins.int
    message_identifier: typing.Text
    """The unique identifier of the response message"""

    error_code: typing.Text
    """An error code describing the error, if any"""

    @property
    def error_message(self) -> axonclient.protos.common_pb2.ErrorMessage:
        """A detailed description of the error"""
        pass
    @property
    def payload(self) -> axonclient.protos.common_pb2.SerializedObject:
        """The payload to provide as a result to the dispatcher"""
        pass
    @property
    def meta_data(
        self,
    ) -> google.protobuf.internal.containers.MessageMap[
        typing.Text, axonclient.protos.common_pb2.MetaDataValue
    ]:
        """Any meta data entries providing contextual information back to the dispatcher"""
        pass
    @property
    def processing_instructions(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        axonclient.protos.common_pb2.ProcessingInstruction
    ]:
        """Instructions for AxonServer when routing this Command Response Message"""
        pass
    request_identifier: typing.Text
    """The unique identifier of the Command Message for which this is the response"""

    def __init__(
        self,
        *,
        message_identifier: typing.Text = ...,
        error_code: typing.Text = ...,
        error_message: typing.Optional[axonclient.protos.common_pb2.ErrorMessage] = ...,
        payload: typing.Optional[axonclient.protos.common_pb2.SerializedObject] = ...,
        meta_data: typing.Optional[
            typing.Mapping[typing.Text, axonclient.protos.common_pb2.MetaDataValue]
        ] = ...,
        processing_instructions: typing.Optional[
            typing.Iterable[axonclient.protos.common_pb2.ProcessingInstruction]
        ] = ...,
        request_identifier: typing.Text = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "error_message", b"error_message", "payload", b"payload"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "error_code",
            b"error_code",
            "error_message",
            b"error_message",
            "message_identifier",
            b"message_identifier",
            "meta_data",
            b"meta_data",
            "payload",
            b"payload",
            "processing_instructions",
            b"processing_instructions",
            "request_identifier",
            b"request_identifier",
        ],
    ) -> None: ...

global___CommandResponse = CommandResponse

class CommandSubscription(google.protobuf.message.Message):
    """Message describing a component's capability of handling a command type"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    MESSAGE_ID_FIELD_NUMBER: builtins.int
    COMMAND_FIELD_NUMBER: builtins.int
    COMPONENT_NAME_FIELD_NUMBER: builtins.int
    CLIENT_ID_FIELD_NUMBER: builtins.int
    LOAD_FACTOR_FIELD_NUMBER: builtins.int
    message_id: typing.Text
    """A unique identifier for this subscription. This identifier is returned in Acknowledgements to allow
    pipelining of subscription messages
    """

    command: typing.Text
    """The name of the command the component can handle"""

    component_name: typing.Text
    """The name/type of the component handling the command"""

    client_id: typing.Text
    """The unique identifier of the component instance subscribing"""

    load_factor: builtins.int
    """A number that represents the client's relative load capacity compared to other clients.
    This information is interpreted by Axon Server in relation to the other connected nodes' values.
    Used to balance the dispatching of commands. If set to 0, Axon Server consider 100 as default value.
    """

    def __init__(
        self,
        *,
        message_id: typing.Text = ...,
        command: typing.Text = ...,
        component_name: typing.Text = ...,
        client_id: typing.Text = ...,
        load_factor: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "client_id",
            b"client_id",
            "command",
            b"command",
            "component_name",
            b"component_name",
            "load_factor",
            b"load_factor",
            "message_id",
            b"message_id",
        ],
    ) -> None: ...

global___CommandSubscription = CommandSubscription
