/*MIT License

Copyright (c) 2019 P. M. Larsen

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.*/


#ifndef CONSTANTS_H
#define CONSTANTS_H

#define INVALID_BRAVAIS_TYPE -101
#define MINKOWSKI_REDUCTION_FAILURE -102


#define TRICLINIC	0
#define MONOCLINIC	1
#define BASEMONOCLINIC	2
#define ORTHORHOMBIC	3
#define BASECO		4
#define BCO		5
#define FCO		6
#define TETRAGONAL	7
#define BCT		8
#define RHOMBOHEDRAL	9
#define HEXAGONAL	10
#define CUBIC		11
#define BCC		12
#define FCC		13

#define aP 0 	//primitive triclinic
#define mP 1	//primitive monoclinic
#define mS 2	//base-centred monoclinic
#define oP 3	//primitive orthorhombic
#define oS 4	//base-centred orthorhombic
#define oF 5	//body-centred orthorhombic
#define oI 6	//face-centred orthorhombic
#define tP 7	//primitive tetragonal
#define tI 8	//body-centred tetragonal
#define hP 9	//primitive rhombohedral
#define hR 10	//primitive hexagonal
#define cP 11	//primitive cubic
#define cF 12	//body-centred cubic
#define cI 13	//face-centred cubic

#endif

