"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicroService = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const autoScalingGroup_1 = require("./autoScalingGroup");
const deployment_1 = require("./deployment");
const network_1 = require("./network");
/**
 * @stability stable
 */
class MicroService extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p;
        super(scope, id);
        this.instanceType = (_b = props === null || props === void 0 ? void 0 : props.instanceType) !== null && _b !== void 0 ? _b : 't3a.micro';
        this.appName = props === null || props === void 0 ? void 0 : props.appName;
        this.volumeSize = (_c = props === null || props === void 0 ? void 0 : props.volumeSize) !== null && _c !== void 0 ? _c : 15;
        this.asgMaxSize = (_d = props === null || props === void 0 ? void 0 : props.asgMaxSize) !== null && _d !== void 0 ? _d : '2';
        this.asgMinSize = (_e = props === null || props === void 0 ? void 0 : props.asgMinSize) !== null && _e !== void 0 ? _e : '1';
        this.env = props === null || props === void 0 ? void 0 : props.env;
        this.instanceLabels = props === null || props === void 0 ? void 0 : props.instanceLabels;
        this.healthCheckPath = (_f = props === null || props === void 0 ? void 0 : props.healthCheckPath) !== null && _f !== void 0 ? _f : '/v1/healthCheck';
        this.port = (_g = props.port) !== null && _g !== void 0 ? _g : undefined;
        this.protocol = (_h = props.protocol) !== null && _h !== void 0 ? _h : 'HTTP';
        this.diskSize = (_j = props.diskSize) !== null && _j !== void 0 ? _j : 8;
        this.vpc = props.vpc;
        this.role = props.role;
        this.tcpRules = props.tcpRules;
        this.subnets = props.subnets;
        this.sslEnabled = props.sslEnabled;
        this.host = props.host;
        this.lbArn = props.lbArn;
        this.sshKey = props.sshKey;
        this.diskType = props.diskType;
        this.createCodedeployApplication = props.createCodedeployApplication;
        this.deploymentPolicies = (_k = props.deploymentPolicies) !== null && _k !== void 0 ? _k : [];
        this.applicationType = (_l = props.applicationType) !== null && _l !== void 0 ? _l : 'new';
        const resourceNamePrefix = this.env + '-' + this.appName;
        const asg = new autoScalingGroup_1.AutoScaler(this, resourceNamePrefix + '-as', {
            asgName: resourceNamePrefix + '-ASG',
            maxSize: this.asgMaxSize,
            minSize: this.asgMinSize,
            tgProps: this.port ? {
                type: 'new',
                healthPath: this.healthCheckPath,
                protocol: this.protocol,
                port: this.port,
                name: ((resourceNamePrefix + '-TG').length >= 32) ? this.env + '-' + this.appName + '-TG' : resourceNamePrefix + '-TG',
                timeout: 10,
                thresholdCount: 2,
            } : undefined,
            templateProps: {
                instanceType: this.instanceType,
                detailedMonitoring: false,
                templateName: resourceNamePrefix + '-LT',
                amiImageId: (_m = props.ami) !== null && _m !== void 0 ? _m : 'Ubuntu Server 20.04 LTS (HVM), SSD Volume Type',
                type: 'new',
                blockDevice: {
                    size: this.diskSize,
                    name: '/dev/sda1',
                    type: this.getDiskType((_o = this.diskType) !== null && _o !== void 0 ? _o : 'GP3'),
                },
                vpc: {
                    type: 'existing',
                    vpcName: this.vpc,
                },
                securityGroup: {
                    type: 'new',
                    allowAllOutbound: true,
                    securityGroupName: resourceNamePrefix + '-SG',
                    ingressRules: this.tcpRules,
                },
                role: this.role,
                sshKey: this.sshKey,
            },
            tags: props.instanceLabels,
            subnets: this.subnets,
        });
        if (this.createCodedeployApplication) {
            const depRole = this.getDeploymentGroupRole();
            const dep = new deployment_1.Deployment(this, resourceNamePrefix + '-cd', {
                asgNames: [resourceNamePrefix + '-ASG'],
                deploymentConfigName: 'CodeDeployDefault.OneAtATime',
                roleArn: depRole.roleArn,
                applicationProps: {
                    applicationName: this.appName + '-' + this.env,
                    type: this.applicationType,
                    resourceType: 'Server',
                },
                deploymentGroupName: this.env,
                tgName: resourceNamePrefix + '-TG',
            });
            dep.node.addDependency(depRole);
        }
        if (this.host && this.lbArn && asg.targetGroupArn != '') {
            const lbEntry = new network_1.BalancerEntry(this, resourceNamePrefix + '-lb', {
                appName: this.appName,
                hostHeader: this.host,
                targetGroupArn: asg.targetGroupArn,
                lbArn: this.lbArn,
                sslEnabled: (_p = this.sslEnabled) !== null && _p !== void 0 ? _p : false,
            });
            lbEntry.node.addDependency(asg);
        }
    }
    getDeploymentGroupRole() {
        var _b;
        var role = new aws_iam_1.Role(this, this.appName + '-deployment-group-role', {
            assumedBy: new aws_iam_1.ServicePrincipal('codedeploy.amazonaws.com'),
            roleName: this.appName + '-deployment-group-role',
        });
        role.addToPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            resources: ['*'],
            actions: [
                'autoscaling:CompleteLifecycleAction',
                'autoscaling:DeleteLifecycleHook',
                'autoscaling:DescribeAutoScalingGroups',
                'autoscaling:DescribeLifecycleHooks',
                'autoscaling:PutLifecycleHook',
                'autoscaling:RecordLifecycleActionHeartbeat',
                'autoscaling:CreateAutoScalingGroup',
                'autoscaling:UpdateAutoScalingGroup',
                'autoscaling:EnableMetricsCollection',
                'autoscaling:DescribePolicies',
                'autoscaling:DescribeScheduledActions',
                'autoscaling:DescribeNotificationConfigurations',
                'autoscaling:SuspendProcesses',
                'autoscaling:ResumeProcesses',
                'autoscaling:AttachLoadBalancers',
                'autoscaling:AttachLoadBalancerTargetGroups',
                'autoscaling:PutScalingPolicy',
                'autoscaling:PutScheduledUpdateGroupAction',
                'autoscaling:PutNotificationConfiguration',
                'autoscaling:PutWarmPool',
                'autoscaling:DescribeScalingActivities',
                'autoscaling:DeleteAutoScalingGroup',
                'ec2:DescribeInstances',
                'ec2:DescribeInstanceStatus',
                'ec2:TerminateInstances',
                'tag:GetResources',
                'sns:Publish',
                'cloudwatch:DescribeAlarms',
                'cloudwatch:PutMetricAlarm',
                'elasticloadbalancing:DescribeLoadBalancers',
                'elasticloadbalancing:DescribeInstanceHealth',
                'elasticloadbalancing:RegisterInstancesWithLoadBalancer',
                'elasticloadbalancing:DeregisterInstancesFromLoadBalancer',
                'elasticloadbalancing:DescribeTargetGroups',
                'elasticloadbalancing:DescribeTargetHealth',
                'elasticloadbalancing:RegisterTargets',
                'elasticloadbalancing:DeregisterTargets',
                'ec2:CreateTags',
                'ec2:RunInstances',
                'iam:PassRole',
                ...(_b = this.deploymentPolicies) !== null && _b !== void 0 ? _b : [],
            ],
        }));
        return role;
    }
    getDiskType(type) {
        return type;
    }
}
exports.MicroService = MicroService;
_a = JSII_RTTI_SYMBOL_1;
MicroService[_a] = { fqn: "@smallcase/aws-cdk-microservice.MicroService", version: "0.0.5" };
//# sourceMappingURL=data:application/json;base64,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