#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Sat Nov 13 17:30:59 2021

@author: hemerson
"""

""" 
standard_value_network -  a simple feedforward value network

"""

import torch
import torch.nn as nn
import torch.nn.functional as F
import torch.autograd as autograd
import math

# This layer was taken directly from: 
# https://github.com/cyoon1729/deep-Q-networks

class factorised_noisy_linear_layer(nn.Module):

    def __init__(self, num_in, num_out, is_training=True, device='cpu'):
        super(factorised_noisy_linear_layer, self).__init__()
        self.num_in = num_in
        self.num_out = num_out 
        self.is_training = is_training
        self.device = device

        self.mu_weight = nn.Parameter(torch.FloatTensor(num_out, num_in).to(self.device))
        self.mu_bias = nn.Parameter(torch.FloatTensor(num_out).to(self.device)) 
        self.sigma_weight = nn.Parameter(torch.FloatTensor(num_out, num_in).to(self.device))
        self.sigma_bias = nn.Parameter(torch.FloatTensor(num_out).to(self.device))
        self.register_buffer("epsilon_i", torch.FloatTensor(num_in).to(self.device))
        self.register_buffer("epsilon_j", torch.FloatTensor(num_out).to(self.device))

        self.reset_parameters()
        self.reset_noise()

    def forward(self, x):
        self.reset_noise()
        
        if self.is_training:
            epsilon_weight = self.epsilon_j.ger(self.epsilon_i)
            epsilon_bias = self.epsilon_j
            weight = self.mu_weight + self.sigma_weight.mul(autograd.Variable(epsilon_weight))
            bias = self.mu_bias + self.sigma_bias.mul(autograd.Variable(epsilon_bias))
        else:
            weight = self.mu_weight
            bias = self.mu_bias

        y = F.linear(x, weight, bias)
        
        return y

    def reset_parameters(self):
        std = 1 / math.sqrt(self.num_in)
        self.mu_weight.data.uniform_(-std, std)
        self.mu_bias.data.uniform_(-std, std)

        self.sigma_weight.data.fill_(0.5 / math.sqrt(self.num_in))
        self.sigma_bias.data.fill_(0.5 / math.sqrt(self.num_in))

    def reset_noise(self):
        eps_i = torch.randn(self.num_in).to(self.device)
        eps_j = torch.randn(self.num_out).to(self.device)
        self.epsilon_i = eps_i.sign() * (eps_i.abs()).sqrt()
        self.epsilon_j = eps_j.sign() * (eps_j.abs()).sqrt()