# Generated by Django 3.1.2 on 2021-02-08 14:39

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Experiment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reference_number', models.IntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='Instrument',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=80)),
                ('is_active', models.BooleanField(default=False)),
                ('is_paused', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='Notification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('message', models.CharField(max_length=255)),
                ('is_active', models.BooleanField(default=True)),
                ('severity', models.CharField(choices=[('i', 'info'), ('w', 'warning'), ('e', 'error')], default='i', max_length=1)),
                ('is_staff_only', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='OutputType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(max_length=50)),
            ],
        ),
        migrations.CreateModel(
            name='Setting',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50)),
                ('value', models.CharField(max_length=50)),
            ],
        ),
        migrations.CreateModel(
            name='Software',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('version', models.CharField(max_length=20)),
            ],
        ),
        migrations.CreateModel(
            name='Status',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('value', models.CharField(choices=[('q', 'Queued'), ('p', 'Processing'), ('s', 'Skipped'), ('c', 'Completed'), ('e', 'Error')], max_length=1)),
            ],
        ),
        migrations.CreateModel(
            name='ReductionRun',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('run_number', models.IntegerField(validators=[django.core.validators.MinValueValidator(0)])),
                ('run_version', models.IntegerField(validators=[django.core.validators.MinValueValidator(0)])),
                ('started_by', models.IntegerField(blank=True, null=True)),
                ('run_name', models.CharField(blank=True, max_length=200)),
                ('admin_log', models.TextField(blank=True)),
                ('graph', models.TextField(blank=True, null=True)),
                ('message', models.TextField(blank=True, null=True)),
                ('reduction_log', models.TextField(blank=True)),
                ('script', models.TextField(validators=[django.core.validators.MaxLengthValidator(100000)])),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('finished', models.DateTimeField(blank=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True)),
                ('retry_when', models.DateTimeField(blank=True, null=True)),
                ('started', models.DateTimeField(blank=True, null=True)),
                ('cancel', models.BooleanField(default=False)),
                ('hidden_in_failviewer', models.BooleanField(default=False)),
                ('overwrite', models.NullBooleanField(default=True)),
                ('experiment', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='reduction_runs', to='reduction_viewer.experiment')),
                ('instrument', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='reduction_runs', to='reduction_viewer.instrument')),
                ('retry_run', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='reduction_viewer.reductionrun')),
                ('software', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='reduction_runs', to='reduction_viewer.software')),
                ('status', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='reduction_viewer.status')),
            ],
        ),
        migrations.CreateModel(
            name='ReductionLocation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file_path', models.CharField(max_length=255)),
                ('reduction_run', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='reduction_location', to='reduction_viewer.reductionrun')),
            ],
        ),
        migrations.CreateModel(
            name='Output',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file_path', models.CharField(max_length=255)),
                ('job', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='output', to='reduction_viewer.reductionrun')),
                ('type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='output', to='reduction_viewer.outputtype')),
            ],
        ),
        migrations.CreateModel(
            name='DataLocation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file_path', models.CharField(max_length=255)),
                ('reduction_run', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='data_location', to='reduction_viewer.reductionrun')),
            ],
        ),
    ]
