import { Construct } from 'constructs';
import { IVerification } from './contract';
import { OriginVerifyProps } from './props';
/**
 * Associates an origin with WAFv2 WebACL to verify traffic contains specific
 * header with a secret value.
 */
export declare class OriginVerify extends Construct implements IVerification {
    /** Origin Request Header Default Name */
    static readonly OriginVerifyHeader = "x-origin-verify";
    /**
     * CloudFront Origin Custom Header name used in the WAFv2 WebACL verification.
     *
     * @default
     * 'x-origin-verify'
     */
    readonly headerName: string;
    /**
     * Secret Value used as the CloudFront Origin Custom Header value.
     *
     * @example
     * 'xxxxEXAMPLESECRET'
     */
    readonly headerValue: string;
    /**
     * Associates an origin with WAFv2 WebACL to verify traffic contains specific
     * header with a secret value.
     *
     * Use `verifyHeader` value to assign custom headers into CloudFront config.
     *
     * @example
     * import { OriginVerify } from '@alma-cdk/origin-verify';
     * import { Distribution } from 'aws-cdk-lib/aws-cloudfront';
     *
     * const api: RestApi; // TODO: implement the RestApi
     * const apiDomain: string; // TODO: implement the domain
     *
     * const verification = new OriginVerify(this, 'OriginVerify', {
     *   origin: api.deploymentStage,
     * });
     *
     * new Distribution(this, 'CDN', {
     *   defaultBehavior: {
     *     origin: new HttpOrigin(apiDomain, {
     *       customHeaders: {
     *         [verification.headerName]: verification.headerValue,
     *       },
     *       protocolPolicy: OriginProtocolPolicy.HTTPS_ONLY,
     *     })
     *   },
     * })
     */
    constructor(scope: Construct, id: string, props: OriginVerifyProps);
    /** Generates a new Secrets Manager Secret if none provided via props. */
    private resolveSecret;
    /** Define a new WAFv2 WebACL. */
    private defineAcl;
    /** Allow traffic with specific header secret. */
    private allowCloudFrontRequests;
    /** Define WAFv2 Statement matching specific header and its value. */
    private allowVerifiedOrigin;
    /** Associates a WAFv2 WebACL into an AWS Resource (defined by ARN). */
    private associate;
    /** Type guard for Application Load Balancer. */
    private isAlb;
    /** Type guard for API Gateway Stage. */
    private isStage;
    private isCfnGraphQLApi;
    /** Resolves origin (either IStage or IApplicationLoadBalancer) ARN. */
    private resolveOriginArn;
    /** Formates API Gateway Stage ARN. */
    private resolveStageArn;
}
