"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Apibara Stream service."""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _DataFinality:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DataFinalityEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _DataFinality.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    DATA_STATUS_UNKNOWN: _DataFinality.ValueType  # 0
    DATA_STATUS_PENDING: _DataFinality.ValueType  # 1
    """Data was received, but is not part of the canonical chain yet."""
    DATA_STATUS_ACCEPTED: _DataFinality.ValueType  # 2
    """Data is now part of the canonical chain, but could still be invalidated."""
    DATA_STATUS_FINALIZED: _DataFinality.ValueType  # 3
    """Data is finalized and cannot be invalidated."""

class DataFinality(_DataFinality, metaclass=_DataFinalityEnumTypeWrapper):
    """Data finality."""

DATA_STATUS_UNKNOWN: DataFinality.ValueType  # 0
DATA_STATUS_PENDING: DataFinality.ValueType  # 1
"""Data was received, but is not part of the canonical chain yet."""
DATA_STATUS_ACCEPTED: DataFinality.ValueType  # 2
"""Data is now part of the canonical chain, but could still be invalidated."""
DATA_STATUS_FINALIZED: DataFinality.ValueType  # 3
"""Data is finalized and cannot be invalidated."""
global___DataFinality = DataFinality

@typing_extensions.final
class StreamDataRequest(google.protobuf.message.Message):
    """Request data to be streamed."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_ID_FIELD_NUMBER: builtins.int
    BATCH_SIZE_FIELD_NUMBER: builtins.int
    STARTING_CURSOR_FIELD_NUMBER: builtins.int
    FINALITY_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    stream_id: builtins.int
    """Used by the client to uniquely identify a stream.
    All streams use `stream_id = 0` by default.
    """
    batch_size: builtins.int
    """How many items to send in a single response."""
    @property
    def starting_cursor(self) -> global___Cursor:
        """Start streaming from the provided cursor."""
    finality: global___DataFinality.ValueType
    """Return data with the specified finality.
    If not specified, defaults to `DATA_STATUS_ACCEPTED`.
    """
    filter: builtins.bytes
    """Return data according to the stream-specific filter."""
    def __init__(
        self,
        *,
        stream_id: builtins.int | None = ...,
        batch_size: builtins.int | None = ...,
        starting_cursor: global___Cursor | None = ...,
        finality: global___DataFinality.ValueType | None = ...,
        filter: builtins.bytes = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "_batch_size",
            b"_batch_size",
            "_finality",
            b"_finality",
            "_stream_id",
            b"_stream_id",
            "batch_size",
            b"batch_size",
            "finality",
            b"finality",
            "starting_cursor",
            b"starting_cursor",
            "stream_id",
            b"stream_id",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "_batch_size",
            b"_batch_size",
            "_finality",
            b"_finality",
            "_stream_id",
            b"_stream_id",
            "batch_size",
            b"batch_size",
            "filter",
            b"filter",
            "finality",
            b"finality",
            "starting_cursor",
            b"starting_cursor",
            "stream_id",
            b"stream_id",
        ],
    ) -> None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_batch_size", b"_batch_size"]
    ) -> typing_extensions.Literal["batch_size"] | None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_finality", b"_finality"]
    ) -> typing_extensions.Literal["finality"] | None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_stream_id", b"_stream_id"]
    ) -> typing_extensions.Literal["stream_id"] | None: ...

global___StreamDataRequest = StreamDataRequest

@typing_extensions.final
class StreamDataResponse(google.protobuf.message.Message):
    """Contains the data requested from the client."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_ID_FIELD_NUMBER: builtins.int
    INVALIDATE_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    HEARTBEAT_FIELD_NUMBER: builtins.int
    stream_id: builtins.int
    """The stream id."""
    @property
    def invalidate(self) -> global___Invalidate: ...
    @property
    def data(self) -> global___Data: ...
    @property
    def heartbeat(self) -> global___Heartbeat: ...
    def __init__(
        self,
        *,
        stream_id: builtins.int = ...,
        invalidate: global___Invalidate | None = ...,
        data: global___Data | None = ...,
        heartbeat: global___Heartbeat | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "data",
            b"data",
            "heartbeat",
            b"heartbeat",
            "invalidate",
            b"invalidate",
            "message",
            b"message",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "data",
            b"data",
            "heartbeat",
            b"heartbeat",
            "invalidate",
            b"invalidate",
            "message",
            b"message",
            "stream_id",
            b"stream_id",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["message", b"message"]
    ) -> typing_extensions.Literal["invalidate", "data", "heartbeat"] | None: ...

global___StreamDataResponse = StreamDataResponse

@typing_extensions.final
class Cursor(google.protobuf.message.Message):
    """A cursor over the stream content."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORDER_KEY_FIELD_NUMBER: builtins.int
    UNIQUE_KEY_FIELD_NUMBER: builtins.int
    order_key: builtins.int
    """Key used for ordering messages in the stream."""
    unique_key: builtins.bytes
    """Key used to discriminate branches in the stream."""
    def __init__(
        self,
        *,
        order_key: builtins.int = ...,
        unique_key: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "order_key", b"order_key", "unique_key", b"unique_key"
        ],
    ) -> None: ...

global___Cursor = Cursor

@typing_extensions.final
class Invalidate(google.protobuf.message.Message):
    """Invalidate data after the given cursor."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CURSOR_FIELD_NUMBER: builtins.int
    @property
    def cursor(self) -> global___Cursor:
        """The cursor of the message before the now invalid data."""
    def __init__(
        self,
        *,
        cursor: global___Cursor | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["cursor", b"cursor"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["cursor", b"cursor"]
    ) -> None: ...

global___Invalidate = Invalidate

@typing_extensions.final
class Data(google.protobuf.message.Message):
    """A batch of data."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    END_CURSOR_FIELD_NUMBER: builtins.int
    FINALITY_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    CURSOR_FIELD_NUMBER: builtins.int
    @property
    def end_cursor(self) -> global___Cursor:
        """Cursor of the last item in the batch."""
    finality: global___DataFinality.ValueType
    """The finality status of the data in the batch."""
    @property
    def data(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
        builtins.bytes
    ]:
        """The stream data."""
    @property
    def cursor(self) -> global___Cursor:
        """Cursor used to produced the batch."""
    def __init__(
        self,
        *,
        end_cursor: global___Cursor | None = ...,
        finality: global___DataFinality.ValueType = ...,
        data: collections.abc.Iterable[builtins.bytes] | None = ...,
        cursor: global___Cursor | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "cursor", b"cursor", "end_cursor", b"end_cursor"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "cursor",
            b"cursor",
            "data",
            b"data",
            "end_cursor",
            b"end_cursor",
            "finality",
            b"finality",
        ],
    ) -> None: ...

global___Data = Data

@typing_extensions.final
class Heartbeat(google.protobuf.message.Message):
    """Sent to clients to check if stream is still connected."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___Heartbeat = Heartbeat
